/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service.redsquare;

import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.runtime.mf.operation.service.redsquare.AbstractRedSquareOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;

public class RegisterOperatorAgentOperation
extends AbstractRedSquareOperation {
    static final String AGENT_SERVICE_TYPE = "RedSquareAgent";
    public static final String AGENT_SCO_PATH = "resources/RedSquareAgent.Default.sco";
    public static final String NAME = "register operator agent";

    public RegisterOperatorAgentOperation() {
        super.createDSLSyntax(NAME);
        this.syntax.addTag(OperationTag.service);
        this.syntax.addTag(OperationTag.red_square);
        this.syntax.setAction("REGISTER OPERATOR AGENT").addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("FROM").addParameter(new SLFilePathParameter("Location"))).setSyntaxHint(SyntaxHint.SPACE)).setRequired(false));
        this.syntax.setAlias("REGISTER OPS AGENT");
        this.syntax.setDescription("Creates and registers RedSquare agent service");
        this.syntax.setExamples("register operator agent\nregister operator agent from 'C:\\StreamScape\\Temp\\stredsquare.jar'");
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractRedSquareOperation.Definition definition = (AbstractRedSquareOperation.Definition)statement;
        String serviceName = ((RuntimeContext)this.callable).getName();
        RepositoryAccessor repository = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (repository.listServicesByType("RedSquareManager").size() > 0) {
            throw new Exception("RedSquare Manager service already registered. Agent and Manager services cannot be registered in one node.");
        }
        if (repository.existsServiceConfiguration(serviceName, AGENT_SERVICE_TYPE)) {
            throw new Exception("RedSquare Agent service already exists.");
        }
        this.importArchive(session, definition, AGENT_SCO_PATH);
        ServiceConfigurationObject sco = this.getServiceSco(AGENT_SCO_PATH);
        sco.setServiceName(serviceName);
        repository.saveServiceConfiguration(sco);
        this.registerService(AGENT_SERVICE_TYPE, serviceName);
        return new SLResponse("RedSquare Agent service created.");
    }
}

