/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service.redsquare;

import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.sef.service.ServiceManagerException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.value.StatementParameterValue;
import java.io.DataInputStream;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractRedSquareOperation
extends AbstractOperation<RuntimeContext> {
    private static final String ARCHIVE_EXTENSION = "jar";

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        String location = null;
        StatementParameterValue locationParameter = statement.getParameter("Location");
        if (locationParameter.isPresent()) {
            location = locationParameter.getValue();
        }
        return new Definition(this.getName(), location);
    }

    private boolean isScoExistsInClassPath(String scoPath) {
        ClassLoader classLoader = ((RuntimeContext)this.callable).getSystemClassLoaderChain();
        URL url = classLoader.getResource(scoPath);
        return url != null;
    }

    protected void importArchive(MFSession session, Definition definition, String scoPath) throws Exception {
        boolean locationSpecified;
        boolean archiveFound = this.isScoExistsInClassPath(scoPath);
        boolean bl = locationSpecified = definition.getLocation() != null;
        if (!locationSpecified && !archiveFound) {
            throw new Exception("RedSquare archive not found. Please import RedSquare jar file or specify 'from' location.");
        }
        if (locationSpecified && archiveFound) {
            throw new Exception("RedSquare archive is already imported.");
        }
        if (locationSpecified) {
            String location = definition.getLocation();
            SLFileUtils utils = (SLFileUtils)new SLFileUtilsFactory().create(session, definition.getLocation());
            if (utils.supportsExistsOperation() && !utils.exists()) {
                throw new Exception("Archive '" + definition.getLocation() + "' does not exist.");
            }
            if (!FilenameUtils.isExtension(location, ARCHIVE_EXTENSION)) {
                throw new Exception("Specified archive is not a 'jar' file.");
            }
            String archiveName = FilenameUtils.getName(location);
            byte[] archiveData = utils.getFileContent(location);
            ((RuntimeContext)this.callable).getRepositoryAccessor().addExtensionArchive(archiveName, archiveData);
        }
    }

    protected ServiceConfigurationObject getServiceSco(String scoPath) throws SerializerException {
        ClassLoader classLoader = ((RuntimeContext)this.callable).getSystemClassLoaderChain();
        DataInputStream in = new DataInputStream(classLoader.getResourceAsStream(scoPath));
        return (ServiceConfigurationObject)((RuntimeContext)this.callable).getXSerializer().deserialize(in);
    }

    protected void registerService(String serviceType, String serviceName) throws ServiceManagerException {
        ServiceDescriptor service = new ServiceDescriptor(serviceType, serviceName);
        service.setAutostart(true);
        ServiceManager serviceManager = ((RuntimeContext)this.callable).getServiceManager();
        serviceManager.registerService(service);
        serviceManager.startService(service.getFullName());
    }

    static class Definition
    extends AbstractSLStatement {
        private final String location;

        Definition(String name, String location) {
            super(name);
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }
    }
}

