/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.mf.operation.service.AbstractLoadUnloadServiceOperation;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.sef.service.ServiceManagerException;
import java.util.List;

public class UnloadServiceOperation
extends AbstractLoadUnloadServiceOperation {
    public static final String NAME = "unload service";

    public UnloadServiceOperation() {
        super(NAME);
        this.syntax.setDescription("Unloads the specified service: unloads service package, unbinds service context\nfrom the Exchange and destroys it.");
        this.syntax.setSyntaxDescription("If only a service type is specified, all service instances of that type will be unloaded.");
        this.syntax.setExamples("unload service TestService.Service1\nunload service TestService");
    }

    @Override
    protected AbstractServiceOperation.ServiceState getCompletionState() {
        return AbstractServiceOperation.ServiceState.LOADED;
    }

    @Override
    protected List<String> getServices(ServiceManager serviceManager) {
        return serviceManager.listLoadedServices();
    }

    @Override
    protected String getOperationName() {
        return "Unload";
    }

    @Override
    protected void doOperation(ServiceManager serviceManager, String serviceName) throws ServiceManagerException {
        serviceManager.unloadServiceContext(serviceName);
    }
}

