/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;

public class StartServiceOperation
extends AbstractServiceOperation {
    public static final String NAME = "start service";

    public StartServiceOperation() {
        super(true, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("START SERVICE").addActionParameter(new AbstractServiceOperation.ServiceTypeNameParameter(AbstractServiceOperation.ServiceState.NOT_RUNNING));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FORCE").setRequired(false)).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("start service       - Starts the specified service.\nstart service force - Starts the specified service without a checking of dependencies.");
        this.syntax.setExamples("start service ExampleType.ExampleName");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getServiceTypeName(statement), statement.getModifier("FORCE").isPresent());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ((RuntimeContext)this.callable).getServiceManager().startService(definition.getServiceName(), definition.isForce());
        return new SLResponse();
    }

    public static class Definition
    extends AbstractServiceOperation.Definition {
        private boolean force;

        public Definition(String serviceName, boolean force) {
            super(StartServiceOperation.NAME, serviceName);
            this.force = force;
        }

        public boolean isForce() {
            return this.force;
        }
    }
}

