/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.service.DescribeServiceOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.List;

public class ShowServiceStateOperation
extends AbstractServiceOperation {
    public static final String NAME = "show service state";

    public ShowServiceStateOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW SERVICE STATE");
        this.syntax.addActionParameter((SyntaxParameter)((ExpressionParameter)new ExpressionParameter("ServiceFullName").setCompactSyntax("[NodeName://]<ServiceType>.<ServiceName>")).setEndDelimiterToCommandEnd());
        this.syntax.setDescription("Shows a current state of the specified service.");
        this.syntax.setExamples("show service state TestService.Service1\nshow service state Node1://TestService.Service1 ");
        this.syntax.addCompletionCommand("list services at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ServiceFullName").getValue());
    }

    @Override
    protected void doInternalParseCompletionResponse(SLResponse response, List<String> completions) {
        DescribeServiceOperation.parseListServicesCompletionResponse(response, completions, (RuntimeContext)this.callable);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        String nodeName = this.getNodeName(((Definition)statement).getServiceName());
        return this.invoke(nodeName, statement, session, timeout, false, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        String serviceName = this.getServiceName(((Definition)statement).getServiceName());
        return new SLResponse(this.getServiceState(serviceName));
    }

    public static class Definition
    extends AbstractServiceOperation.Definition {
        public Definition(String serviceName) {
            super(ShowServiceStateOperation.NAME, serviceName);
        }
    }
}

