/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.runtime.mf.operation.service.PropertyTypeSyntaxes;
import com.streamscape.service.osf.config.ServiceConfigurationProperties;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.registry.ConfigurationProperties;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementModifierValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class ServicePropertiesSyntax {
    public static AbstractModifier<?> createServicePropertiesCreateSyntax() throws RuntimeException {
        return ServicePropertiesSyntax.createServicePropertiesFullSyntax("PROPERTIES");
    }

    public static AbstractModifier<?> createServicePropertiesAlterSyntax(boolean withAddProperty) throws RuntimeException {
        return ServicePropertiesSyntax.createServicePropertiesFullSyntax(withAddProperty ? "ADD PROPERTY" : "");
    }

    public static AbstractModifier<?> createServicePropertiesFullSyntax(String modifierName) throws RuntimeException {
        CompoundModifier compound = new CompoundModifier("propertiescompound");
        if (modifierName != null && modifierName.length() > 0) {
            compound.addModifier(new Modifier(modifierName)).setRequired(false);
        }
        compound.addModifier(ServicePropertiesSyntax.createServicePropertiesBlockSyntax()).setSyntaxHint(new SyntaxHint(" ", true));
        return compound;
    }

    public static AbstractModifier<?> createServicePropertiesBlockSyntax() throws RuntimeException {
        BlockModifier block = new BlockModifier("", "PropertiesBlock");
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.STRING).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.URL).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.PASSWORD).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.XML).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.TEXT).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.SQL).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.NUMERIC).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.DECIMAL).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.ENUMERATION).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.BOOLEAN).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.JDBC_FACTORY).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.TRANSPORT_FACTORY).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.CLIENT_FACTORY).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(PropertyTypeSyntaxes.getPropertySyntax(ServicePropertyType.OBJECT).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(new PropertyTypeSyntaxes.ListPropertySyntax(block).getSyntax()));
        block.addModifier(ServicePropertiesSyntax.wrapToRepatable(new PropertyTypeSyntaxes.TablePropertySyntax(block).getSyntax()));
        block.setCompactSyntax("(\n   {string | url | password | xml | text | sql | numeric | decimal | enumeration | boolean} <PropertyName>\n      [= {'<PropertyValue>' | <PropertyValue>}] [range ({'<Value1>' | <Value1>},... )]\n      [label '<labelName>'] [description '<description>'] [group '<groupName>'] [required],...,\n   {jdbc_factory | transport_factory | client_factory } <PropertyName> [ type <FactoryType>] \n      [lable '<labelName>'] [description '<description>'] [group '<groupName>'] [required],...,\n   object <PropertyName> [ type <ObjectType>] [ctx_namespace '<ctxNamespace>'] [range (<ObjectType>.<ObjectName>,... )]\n      [label '<labelName>'] [description '<description>'] [group '<groupName>'] [required],...,\n   {list | table} <PropertyName> [(<property>, ...)] [label '<labelName>'] [description '<description>'] [group '<groupName>'] [required],...,\n)");
        return block;
    }

    protected static RepeatableModifier wrapToRepatable(AbstractModifier<?> modifier) {
        return (RepeatableModifier)((RepeatableModifier)new RepeatableModifier(modifier.getName() + "line").addModifier(modifier)).setSyntaxHint(new SyntaxHint(" ", true));
    }

    public static ConfigurationProperties parseServiceProperties(DSLStatement statement) throws Exception {
        if (statement.getBlock("PropertiesBlock").isPresent()) {
            return ServicePropertiesSyntax.parseServiceProperties(statement.getBlock("PropertiesBlock"));
        }
        return null;
    }

    public static void parseServiceProperties(ServiceConfigurationProperties properties, DSLStatement statement) throws Exception {
        if (statement.getBlock("PropertiesBlock").isPresent()) {
            ServicePropertiesSyntax.parseServiceProperties(properties, statement.getBlock("PropertiesBlock"));
        }
    }

    public static ConfigurationProperties parseServiceProperties(StatementBlockValue body) throws Exception {
        ConfigurationProperties properties = new ConfigurationProperties();
        ServicePropertiesSyntax.parseServiceProperties((ServiceConfigurationProperties)properties, body);
        return properties;
    }

    public static void parseServiceProperties(ServiceConfigurationProperties properties, StatementBlockValue body) throws Exception {
        ServicePropertiesSyntax.parseServiceProperties(body, (ServiceConfigurationProperty property) -> properties.addProperty(property));
    }

    public static void parseServiceProperties(StatementBlockValue body, PropertyObserver observer) throws Exception {
        for (int index = 0; index < body.getLinesCount(); ++index) {
            StatementValueList line = body.getLineByIndex(index);
            try {
                StatementModifierValue propertyTypeModifier = line.getModifier("PropertyType");
                if (!propertyTypeModifier.isPresent()) {
                    throw new Exception("Modifier 'PropertyType' is missing.");
                }
                PropertyTypeSyntaxes.PropertySyntax propertySyntax = PropertyTypeSyntaxes.getPropertySyntax(propertyTypeModifier.getToken());
                observer.onProperty(propertySyntax.parse(line));
                continue;
            }
            catch (Exception exception) {
                throw new Exception("Failed to process line '" + line.toString() + "'. Cause: " + exception.getMessage());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        DSLStatementSyntax syntax = new DSLStatementSyntax("Create service type operation.");
        syntax.setAction("CREATE SERVICE TYPE").addActionParameter(new IdentifierParameter("ServiceType"));
        syntax.addModifier(ServicePropertiesSyntax.createServicePropertiesCreateSyntax());
        syntax.validate();
        System.out.println(syntax.getSyntax());
        System.out.println(syntax.getFullSyntax());
        String testscript = "create service type Type\nPROPERTIES (\n  NUMERIC worker.threads = 5 RANGE(5,6) DESCRIPTION 'wer',\n  LIST monitors (\n    STRING str = 'sample',\n    STRING str1 = 'sample'\n  ),\n  TABLE monitorstable (\n    STRING str = 'sample',\n    STRING str1 = 'sample',\n    LIST monitors (\n      STRING str = 'sample',\n      STRING str1 = 'sample'\n    ) DESCRIPTION 'asdfsadgas'\n  ),\n  LIST monitors1,\n  ENUMERATION enum1 = er RANGE(q,er), \n  BOOLEAN boolean1 = TRUE,\n  OBJECT object1 TYPE Type1 CTX_NAMESPACE 'qwe',\n  JDBC_FACTORY factory1 TYPE T\n)";
        DSLStatement statement = syntax.parse(testscript);
        System.out.println(statement.toString());
        ConfigurationProperties properties = ServicePropertiesSyntax.parseServiceProperties(statement);
        System.out.println(XSerializerFactory.getInstance().createSerializer("qwe").serialize(properties));
    }

    public static interface PropertyObserver {
        public void onProperty(ServiceConfigurationProperty var1) throws Exception;
    }
}

