/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.service.osf.config.EventHandlersConfiguration;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.service.osf.registry.EventHandlers;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.modifier.SetModifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.NumericParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class ServiceHandlersSyntax {
    public static AbstractModifier<?> createServiceHandlersCreateSyntax() throws RuntimeException {
        return ServiceHandlersSyntax.createServiceHandlersFullSyntax("HANDLERS");
    }

    public static AbstractModifier<?> createServiceHandlersAlterSyntax() throws RuntimeException {
        return ServiceHandlersSyntax.createServiceHandlersFullSyntax("ADD HANDLER");
    }

    public static AbstractModifier<?> createServiceHandlersFullSyntax(String modifierName) throws RuntimeException {
        return (AbstractModifier)((CompoundModifier)new CompoundModifier("handlerscompound").addModifier(new Modifier(modifierName)).addModifier(ServiceHandlersSyntax.createServiceHandlersBlockSyntax()).setRequired(false)).setSyntaxHint(new SyntaxHint(" ", true));
    }

    public static AbstractModifier<?> createServiceHandlersBlockSyntax() throws RuntimeException {
        BlockModifier block = new BlockModifier("", "HandlersBlock");
        CompoundModifier handler = new CompoundModifier();
        handler.addParameter(new IdentifierParameter("handlerName"));
        handler.addModifier((AbstractModifier)new Modifier("METHOD").addParameter(new IdentifierParameter("methodName")));
        CompoundModifier requestCompoundModifier = new CompoundModifier("requestcompoundmodifier");
        requestCompoundModifier.addModifier((AbstractModifier)new Modifier("EVENT").addParameter(new EventIdParameter("eventId")));
        requestCompoundModifier.addModifier((AbstractModifier)((Modifier)new Modifier("SELECTOR").addParameter(new StringParameter("selector"))).setRequired(false));
        requestCompoundModifier.addModifier((AbstractModifier)new CompoundModifier("semtypecompound").addModifier((AbstractModifier)new Modifier("TYPE").addParameter(new IdentifierParameter("semanticType"))).addModifier((AbstractModifier)((Modifier)new Modifier("TYPE ELEMENT").addParameter(new StringParameter("typeSDRPath"))).setRequired(false)).setRequired(false));
        handler.addModifier(new CompoundModifier("requestsetcompoundmodifier").addModifier(new Modifier("REQUEST")).addModifier(new SetModifier("REQUESTSET").addModifier(requestCompoundModifier)));
        CompoundModifier responseCompoundModifier = new CompoundModifier("responsecompoundmodifier");
        responseCompoundModifier.addModifier((AbstractModifier)new Modifier("EVENT").addParameter(new EventIdParameter("eventId")));
        responseCompoundModifier.addModifier((AbstractModifier)((Modifier)new Modifier("TYPE").addParameter(new IdentifierParameter("semanticType"))).setRequired(false));
        handler.addModifier((AbstractModifier)new CompoundModifier("responsesetcompoundmodifier").addModifier(new Modifier("RESPONSE")).addModifier(new SetModifier("RESPONSESET").addModifier(responseCompoundModifier)).setRequired(false));
        handler.addModifier((AbstractModifier)((Modifier)new Modifier("INVOKE MODE").addParameter(new EnumParameter("invokeMode", InvokeMode.class))).setRequired(false));
        handler.addModifier((AbstractModifier)((Modifier)new Modifier("TIMEOUT").addParameter(new NumericParameter("timeout"))).setRequired(false));
        block.addModifier((AbstractModifier)((RepeatableModifier)new RepeatableModifier("handlerline").addModifier(handler)).setSyntaxHint(new SyntaxHint("   ", true)));
        return block;
    }

    public static EventHandlers parseServiceHandlers(DSLStatement statement) throws Exception {
        if (statement.getBlock("HandlersBlock").isPresent()) {
            return ServiceHandlersSyntax.parseServiceHandlers(statement.getBlock("HandlersBlock"));
        }
        return null;
    }

    public static void parseServiceHandlers(ServiceConfigurationObject sco, DSLStatement statement) throws Exception {
        if (statement.getBlock("HandlersBlock").isPresent()) {
            ServiceHandlersSyntax.parseServiceHandlers(sco, sco, statement.getBlock("HandlersBlock"));
        }
    }

    public static EventHandlers parseServiceHandlers(StatementBlockValue body) throws Exception {
        EventHandlers handlers = new EventHandlers();
        ServiceHandlersSyntax.parseServiceHandlers(null, handlers, body);
        return handlers;
    }

    public static void parseServiceHandlers(ServiceConfigurationObject sco, final EventHandlersConfiguration handlers, StatementBlockValue body) throws Exception {
        ServiceHandlersSyntax.parseServiceHandlers(sco, body, new HandlerObserver(){

            @Override
            public void onHandler(EventHandler handler) throws Exception {
                handlers.addEventHandler(handler);
            }
        });
    }

    public static void parseServiceHandlers(ServiceConfigurationObject sco, StatementBlockValue body, HandlerObserver observer) throws Exception {
        for (int index = 0; index < body.getLinesCount(); ++index) {
            StatementValueList line = body.getLineByIndex(index);
            try {
                String eventId;
                EventHandler handler = new EventHandler();
                handler.setHandlerName(line.getParameter("handlerName").getValue());
                handler.setMethodName(line.getParameter("methodName").getValue());
                handler.setServiceConfigurationObject(sco);
                if (line.getSet("REQUESTSET").isPresent()) {
                    StatementValueList request = line.getSet("REQUESTSET").getElement(0);
                    eventId = request.getParameter("eventId").getValue();
                    if (request.getParameter("semanticType").isPresent()) {
                        handler.bindRequestObject(eventId, request.getParameter("semanticType").getValue());
                    } else {
                        handler.bindVoidRequestObject(eventId);
                    }
                    if (request.getParameter("selector").isPresent()) {
                        handler.setRequestSelector(request.getParameter("selector").getValue());
                    }
                    if (request.getParameter("typeSDRPath").isPresent()) {
                        handler.setRequestSDRPath(request.getParameter("typeSDRPath").getValue());
                    }
                }
                if (line.getSet("RESPONSESET").isPresent()) {
                    StatementValueList response = line.getSet("RESPONSESET").getElement(0);
                    eventId = response.getParameter("eventId").getValue();
                    if (response.getParameter("semanticType").isPresent()) {
                        handler.bindResponseObject(eventId, response.getParameter("semanticType").getValue());
                    } else {
                        handler.bindVoidResponseObject(eventId);
                    }
                }
                if (line.getParameter("invokeMode").isPresent()) {
                    handler.setInvokeMode(InvokeMode.valueOf(line.getParameter("invokeMode").getValue().toUpperCase()));
                }
                if (line.getParameter("timeout").isPresent()) {
                    handler.setTimeout(Long.parseLong(line.getParameter("timeout").getValue()));
                }
                observer.onHandler(handler);
                continue;
            }
            catch (Exception exception) {
                throw new Exception("Failed to process line '" + line.toString() + "'. Cause: " + exception.getMessage());
            }
        }
    }

    public static interface HandlerObserver {
        public void onHandler(EventHandler var1) throws Exception;
    }
}

