/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class RenameServiceOperation
extends AbstractServiceOperation {
    public static String NAME = "rename service";

    public RenameServiceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("RENAME SERVICE").addActionParameter(new AbstractServiceOperation.ServiceTypeNameParameter(AbstractServiceOperation.ServiceState.ALL));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TO").addParameter(new IdentifierParameter("new name"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Renames existing service.\n\nNOTE: References to old service in dataspace script will remain the same.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ServiceType").getValue(), statement.getParameter("ServiceName").getValue(), statement.getParameter("new name").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        String serviceFullName = definition.serviceType + "." + definition.serviceName;
        String serviceFullNameNew = definition.serviceType + "." + definition.newServiceName;
        if (!ServiceConfigurationFactory.existsConfigurationObject(definition.serviceName, definition.serviceType)) {
            throw new Exception("Service " + serviceFullName + " does not exist.");
        }
        if (ServiceConfigurationFactory.existsConfigurationObject(definition.newServiceName, definition.serviceType)) {
            throw new Exception("Service " + serviceFullNameNew + " already exists.");
        }
        boolean serviceStarted = false;
        boolean serviceLoaded = false;
        boolean serviceRegistered = false;
        ServiceDescriptor serviceDescriptor = null;
        ServiceManager serviceManager = ((RuntimeContext)this.callable).getServiceManager();
        if (serviceManager.isServiceRunning(serviceFullName)) {
            serviceStarted = true;
            SLOperationLogger.log(this, "\nStopping service " + serviceFullName + "...");
            serviceManager.stopService(serviceFullName);
        }
        if (serviceManager.isServiceLoaded(serviceFullName)) {
            serviceLoaded = true;
            SLOperationLogger.log(this, "\nUnloading service " + serviceFullName + "...");
            serviceManager.unloadServiceContext(serviceFullName);
        }
        if (serviceManager.isServiceRegistered(serviceFullName)) {
            serviceRegistered = true;
            SLOperationLogger.log(this, "\nUnregistering service " + serviceFullName + "...");
            serviceDescriptor = serviceManager.getService(serviceFullName);
            serviceManager.unregisterService(serviceFullName);
        }
        ServiceConfigurationObject sco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)this.callable, definition.serviceName, definition.serviceType, true);
        SLOperationLogger.log(this, "\nRemoving SCO for service " + serviceFullName + "...\n");
        ServiceConfigurationFactory.removeConfigurationObject(definition.serviceName, definition.serviceType);
        SLOperationLogger.log(this, "Saving SCO for service " + serviceFullNameNew + "...\n");
        sco.setServiceName(definition.newServiceName);
        ServiceConfigurationFactory.saveConfigurationObject(sco);
        if (serviceRegistered) {
            SLOperationLogger.log(this, "Registering service " + serviceFullNameNew + "...\n");
            ServiceDescriptor serviceDescriptorNew = new ServiceDescriptor(serviceFullNameNew);
            serviceDescriptorNew.setAutostart(serviceDescriptor.isAutostart());
            serviceDescriptorNew.setCredentials(serviceDescriptor.getCredentials());
            serviceDescriptorNew.setLogBroadcast(serviceDescriptor.getLogBroadcast());
            serviceDescriptorNew.setLogLevel(serviceDescriptor.getLogLevel());
            serviceDescriptorNew.setDependencies(serviceDescriptor.getDependencies());
            serviceManager.registerService(serviceDescriptorNew);
        }
        if (serviceLoaded) {
            SLOperationLogger.log(this, "Loading service " + serviceFullNameNew + "...\n");
            serviceManager.loadServiceContext(serviceFullNameNew);
        }
        if (serviceStarted) {
            SLOperationLogger.log(this, "Starting service " + serviceFullNameNew + "...\n");
            serviceManager.startService(serviceFullNameNew);
        }
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        String serviceType;
        String serviceName;
        String newServiceName;

        Definition(String serviceType, String serviceName, String newServiceName) {
            super(NAME);
            this.serviceType = serviceType;
            this.serviceName = serviceName;
            this.newServiceName = newServiceName;
        }
    }
}

