/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.StringTokenizer;

public class RegisterServiceOperation
extends AbstractServiceOperation {
    public static final String NAME = "register service";

    public RegisterServiceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REGISTER SERVICE").addActionParameter(new AbstractServiceOperation.ServiceTypeNameParameter(AbstractServiceOperation.ServiceState.NOT_REGISTERED));
        this.syntax.addModifier(new AbstractServiceOperation.ServiceAutostartParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServiceSequenceParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServicePrincipalParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServicePasswordParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServiceLogLevelParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServiceLogBroadcastParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServiceDependsOnParameter(AbstractServiceOperation.ServiceState.REGISTERED));
        this.syntax.setDescription("Registers the specified service in the Service Manager.");
        this.syntax.setExamples("register service ExampleType.ExampleName\nregister service ExampleType.ExampleName autostart true\nregister service ExampleType.ExampleName autostart true log_level info depends on(Type1.Name1,Type2.Name2)");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parseManifestSyntax(statement, null);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ServiceManager serviceManager = ((RuntimeContext)this.callable).getServiceManager();
        StringTokenizer tokenizer = new StringTokenizer(definition.getServiceName(), ".");
        ServiceDescriptor service = new ServiceDescriptor(tokenizer.nextToken(), tokenizer.nextToken());
        if (service.getName().equals("prototype")) {
            throw new Exception("Register of service prototype is not allowed. Create service instance based on prototype and then register created instance.");
        }
        service.setAutostart(definition.isAutostart());
        if (definition.getLogLevel() != null) {
            service.setLogLevel(definition.getLogLevel());
        }
        service.setLogBroadcast(definition.isLogBroadcast());
        for (String dependency : definition.getDependencies()) {
            service.addDependency(dependency);
        }
        if (definition.getSequence() != -1) {
            serviceManager.registerService(definition.getSequence(), service);
        } else {
            serviceManager.registerService(service);
        }
        if (definition.getPrincipal() != null) {
            serviceManager.runServiceAs(definition.getServiceName(), definition.getPrincipal(), definition.getPassword());
        }
        return new SLResponse();
    }

    @Override
    protected AbstractServiceOperation.ManifestDefinition createManifestDefinition(String serviceTypeName) {
        return new Definition(serviceTypeName);
    }

    public static class Definition
    extends AbstractServiceOperation.ManifestDefinition {
        public Definition(String serviceName) {
            super(RegisterServiceOperation.NAME, serviceName);
        }
    }
}

