/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.mf.operation.service.ServicePropertiesSyntax;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.JDBCFactoryPropertyValue;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.PasswordPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.config.TransportFactoryPropertyValue;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.BooleanParameter;
import com.streamscape.slex.lang.parameter.DoubleParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.NumericParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementModifierValue;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class PropertyTypeSyntaxes {
    private static Map<ServicePropertyType, PropertySyntax> propertySyntaxes = new HashMap<ServicePropertyType, PropertySyntax>();

    private static void addProperty(PropertySyntax property) {
        propertySyntaxes.put(property.getType(), property);
    }

    public static PropertySyntax getPropertySyntax(ServicePropertyType type) throws RuntimeException {
        PropertySyntax propertyType = propertySyntaxes.get((Object)type);
        if (propertyType == null) {
            throw new RuntimeException("Unsupportable property type '" + String.valueOf((Object)type) + "'.");
        }
        return propertyType;
    }

    public static PropertySyntax getPropertySyntax(String type) throws RuntimeException {
        ServicePropertyType enumType = ServicePropertyType.valueOf(type.toUpperCase());
        return PropertyTypeSyntaxes.getPropertySyntax(enumType);
    }

    static {
        PropertyTypeSyntaxes.addProperty(new StringPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new URLPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new PasswordPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new XMLPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new TextPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new SQLPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new NumericPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new DecimalPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new EnumerationPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new BooleanPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new JDBCFactoryPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new TransportFactoryPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new ClientFactoryPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new ListPropertySyntax());
        PropertyTypeSyntaxes.addProperty(new TablePropertySyntax());
        PropertyTypeSyntaxes.addProperty(new ObjectPropertySyntax());
    }

    public static interface PropertySyntax {
        public ServicePropertyType getType();

        public AbstractModifier<?> getSyntax();

        public ServiceConfigurationProperty parse(StatementValueList var1) throws Exception;
    }

    public static class StringPropertySyntax
    extends AbstractStringPropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.STRING;
        }
    }

    public static class URLPropertySyntax
    extends AbstractStringPropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.URL;
        }

        @Override
        protected Object onParsePropertyValue(String value) throws Exception {
            return new URI(value);
        }
    }

    public static class PasswordPropertySyntax
    extends AbstractStringPropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.PASSWORD;
        }

        @Override
        protected Object onParsePropertyValue(String value) throws Exception {
            return new PasswordPropertyValue(value);
        }
    }

    public static class XMLPropertySyntax
    extends AbstractStringPropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.XML;
        }
    }

    public static class TextPropertySyntax
    extends AbstractStringPropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.TEXT;
        }
    }

    public static class SQLPropertySyntax
    extends AbstractStringPropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.SQL;
        }
    }

    public static class NumericPropertySyntax
    extends AbstractPropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.NUMERIC;
        }

        @Override
        protected Object onParsePropertyValue(String value) throws Exception {
            return Long.valueOf(value);
        }

        @Override
        protected AbstractParameter<?> getPropertyValueSyntax(String name) {
            return new NumericParameter(name);
        }
    }

    public static class DecimalPropertySyntax
    extends AbstractPropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.DECIMAL;
        }

        @Override
        protected Object onParsePropertyValue(String value) throws Exception {
            return Double.valueOf(value);
        }

        @Override
        protected AbstractParameter<?> getPropertyValueSyntax(String name) {
            return new DoubleParameter(name);
        }
    }

    static class EnumerationPropertySyntax
    extends AbstractPropertySyntax {
        EnumerationPropertySyntax() {
        }

        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.ENUMERATION;
        }

        @Override
        public AbstractModifier<?> getSyntax() {
            CompoundModifier syntax = (CompoundModifier)super.getSyntax();
            if (syntax.getElement("RANGE") != null && syntax.getElement("RANGE") instanceof AbstractModifier) {
                ((AbstractModifier)syntax.getElement("RANGE")).setRequired(true);
            }
            return syntax;
        }

        @Override
        protected AbstractParameter<?> getPropertyValueSyntax(String name) {
            return new IdentifierParameter(name);
        }

        @Override
        protected Object onParsePropertyValue(String value) throws Exception {
            return value;
        }
    }

    static class BooleanPropertySyntax
    extends AbstractPropertySyntax {
        BooleanPropertySyntax() {
        }

        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.BOOLEAN;
        }

        @Override
        protected AbstractParameter<?> getPropertyValueSyntax(String name) {
            return new BooleanParameter(name);
        }

        @Override
        protected Object onParsePropertyValue(String value) throws Exception {
            return value.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class JDBCFactoryPropertySyntax
    extends AbstractFactoryPropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.JDBC_FACTORY;
        }

        @Override
        protected Object createFactoryObject(String type, String name) {
            return new JDBCFactoryPropertyValue(name, type);
        }
    }

    public static class TransportFactoryPropertySyntax
    extends AbstractFactoryPropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.TRANSPORT_FACTORY;
        }

        @Override
        protected Object createFactoryObject(String type, String name) {
            return new TransportFactoryPropertyValue(name, type);
        }
    }

    public static class ClientFactoryPropertySyntax
    extends AbstractFactoryPropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.CLIENT_FACTORY;
        }

        @Override
        protected Object createFactoryObject(String type, String name) {
            return new ClientFactoryPropertyValue(name, type);
        }
    }

    public static class ListPropertySyntax
    extends AbstractListTablePropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.LIST;
        }

        ListPropertySyntax() {
        }

        ListPropertySyntax(BlockModifier block) {
            super(block);
        }

        @Override
        protected Object onParse(StatementBlockValue body) throws Exception {
            final ArrayList result = new ArrayList();
            ServicePropertiesSyntax.parseServiceProperties(body, new ServicePropertiesSyntax.PropertyObserver(){

                @Override
                public void onProperty(ServiceConfigurationProperty property) throws Exception {
                    result.add(property);
                }
            });
            return result;
        }
    }

    public static class TablePropertySyntax
    extends AbstractListTablePropertySyntax {
        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.TABLE;
        }

        TablePropertySyntax() {
        }

        TablePropertySyntax(BlockModifier block) {
            super(block);
        }

        @Override
        protected Object onParse(StatementBlockValue body) throws Exception {
            final Hashtable result = new Hashtable();
            ServicePropertiesSyntax.parseServiceProperties(body, new ServicePropertiesSyntax.PropertyObserver(){

                @Override
                public void onProperty(ServiceConfigurationProperty property) throws Exception {
                    result.put(property.getName(), property);
                }
            });
            return result;
        }
    }

    static class ObjectPropertySyntax
    extends AbstractFactoryObjectPropertySyntax {
        ObjectPropertySyntax() {
        }

        @Override
        public ServicePropertyType getType() {
            return ServicePropertyType.OBJECT;
        }

        @Override
        public AbstractModifier<?> getSyntax() {
            CompoundModifier syntax = (CompoundModifier)super.getSyntax();
            syntax.addModifierAt(3, (AbstractModifier)new Modifier("CTX_NAMESPACE").addParameter(new StringParameter("ctxNamespace")));
            return syntax;
        }

        @Override
        protected String getTypeParameterName() {
            return "ObjectType";
        }

        @Override
        protected Object onParsePropertyValue(StatementValueList line) throws Exception {
            String objectName = "ObjectName";
            String objectType = "ObjectType";
            ReferenceContext context = new ReferenceContext(ReferenceContext.ROOT, "path");
            if (line.getParameter(this.getTypeParameterName()).isPresent()) {
                objectType = line.getParameter(this.getTypeParameterName()).getValue();
            }
            if (line.getParameter("ctxNamespace").isPresent()) {
                context = new ReferenceContext(ReferenceContext.ROOT, line.getParameter("ctxNamespace").getValue());
            }
            return new ObjectPropertyValue(objectName, objectType, context);
        }
    }

    static abstract class AbstractListTablePropertySyntax
    implements PropertySyntax {
        private BlockModifier block;

        AbstractListTablePropertySyntax() {
        }

        AbstractListTablePropertySyntax(BlockModifier block) {
            this.block = block;
        }

        @Override
        public AbstractModifier<?> getSyntax() {
            if (this.block == null) {
                throw new RuntimeException("Block modifier should be set for AbstractListTablePropertySyntax before getSyntax call.");
            }
            CompoundModifier syntax = new CompoundModifier(String.valueOf((Object)this.getType()) + "propertycompound");
            syntax.addModifier((AbstractModifier)new Modifier(this.getType().toString()).setName("PropertyType"));
            syntax.addParameter((AbstractParameter)new IdentifierParameter("PropertyName").setName("PropertyName"));
            CompoundModifier equlasModifier = (CompoundModifier)new CompoundModifier("equlascompoundmodifier").addModifier(this.block).setRequired(false);
            equlasModifier.setCompactSyntax("[ (<property>, ...)]");
            syntax.addModifier(equlasModifier);
            AbstractPropertySyntax.appendStaticPropertyModifiersExceptRange(syntax);
            return syntax;
        }

        @Override
        public ServiceConfigurationProperty parse(StatementValueList line) throws Exception {
            ServiceConfigurationProperty property = AbstractPropertySyntax.createProperty(line, this);
            AbstractPropertySyntax.parseStaticPropertyModifiersExceptRange(line, property);
            StatementModifierValue bodyModifier = line.getModifier("PropertiesBlock");
            if (bodyModifier.isPresent() && bodyModifier instanceof StatementBlockValue) {
                StatementBlockValue body = (StatementBlockValue)bodyModifier;
                property.setDefault(this.onParse(body));
            }
            return property;
        }

        protected abstract Object onParse(StatementBlockValue var1) throws Exception;
    }

    static abstract class AbstractFactoryPropertySyntax
    extends AbstractFactoryObjectPropertySyntax {
        AbstractFactoryPropertySyntax() {
        }

        @Override
        protected String getTypeParameterName() {
            return "FactoryType";
        }

        @Override
        protected Object onParsePropertyValue(StatementValueList line) throws Exception {
            String factoryType = "FactoryType";
            if (line.getParameter(this.getTypeParameterName()).isPresent()) {
                factoryType = line.getParameter(this.getTypeParameterName()).getValue();
            }
            return this.createFactoryObject(factoryType, "FactoryName");
        }

        protected abstract Object createFactoryObject(String var1, String var2);
    }

    static abstract class AbstractFactoryObjectPropertySyntax
    implements PropertySyntax {
        AbstractFactoryObjectPropertySyntax() {
        }

        @Override
        public AbstractModifier<?> getSyntax() {
            CompoundModifier syntax = new CompoundModifier(String.valueOf((Object)this.getType()) + "propertycompound");
            syntax.addModifier((AbstractModifier)new Modifier(this.getType().toString()).setName("PropertyType"));
            syntax.addParameter((AbstractParameter)new IdentifierParameter("PropertyName").setName("PropertyName"));
            syntax.addModifier((AbstractModifier)new Modifier("TYPE").addParameter(new IdentifierParameter(this.getTypeParameterName())));
            AbstractPropertySyntax.appendStaticPropertyModifiersExceptRange(syntax);
            return syntax;
        }

        @Override
        public ServiceConfigurationProperty parse(StatementValueList line) throws Exception {
            ServiceConfigurationProperty property = AbstractPropertySyntax.createProperty(line, this);
            AbstractPropertySyntax.parseStaticPropertyModifiersExceptRange(line, property);
            property.setDefault(this.onParsePropertyValue(line));
            return property;
        }

        protected abstract String getTypeParameterName();

        protected abstract Object onParsePropertyValue(StatementValueList var1) throws Exception;
    }

    static abstract class AbstractStringPropertySyntax
    extends AbstractPropertySyntax {
        AbstractStringPropertySyntax() {
        }

        @Override
        protected AbstractParameter<?> getPropertyValueSyntax(String name) {
            return new StringParameter(name);
        }

        @Override
        protected Object onParsePropertyValue(String value) throws Exception {
            return value;
        }
    }

    public static abstract class AbstractPropertySyntax
    implements PropertySyntax {
        @Override
        public AbstractModifier<?> getSyntax() {
            CompoundModifier syntax = new CompoundModifier(String.valueOf((Object)this.getType()) + "propertycompound");
            syntax.addModifier((AbstractModifier)new Modifier(this.getType().toString()).setName("PropertyType"));
            syntax.addParameter((AbstractParameter)new IdentifierParameter("PropertyName").setName("PropertyName"));
            syntax.addModifier((AbstractModifier)((Modifier)new Modifier("=", "equals").addParameter(this.getPropertyValueSyntax("DefaultValue"))).setRequired(false));
            this.appendStaticPropertyModifiers(syntax);
            return syntax;
        }

        protected abstract AbstractParameter<?> getPropertyValueSyntax(String var1);

        protected abstract Object onParsePropertyValue(String var1) throws Exception;

        public Object parsePropertyValue(String value) throws Exception {
            if (value == null) {
                return null;
            }
            try {
                return this.onParsePropertyValue(value);
            }
            catch (Exception exception) {
                throw new Exception("Failed to parse property value '" + value + "'. Cause: " + exception.getMessage());
            }
        }

        protected void appendStaticPropertyModifiers(CompoundModifier modifier) {
            modifier.addModifier((AbstractModifier)((Modifier)new Modifier("RANGE").addParameter(new SetParameter("rangeparameter").addParameter(this.getPropertyValueSyntax("Value1")))).setRequired(false));
            AbstractPropertySyntax.appendStaticPropertyModifiersExceptRange(modifier);
        }

        protected void parseRangeModifier(StatementValueList line, ServiceConfigurationProperty property) {
            StatementSetValue range = line.getSet("rangeparameter");
            if (!range.isPresent()) {
                return;
            }
            StringBuilder stringRange = new StringBuilder();
            for (int i = 0; i < range.size(); ++i) {
                if (i > 0) {
                    stringRange.append(",");
                }
                stringRange.append(((StatementParameterValue)range.getElement(i).getValue(0)).getValue());
            }
            property.setRange(stringRange.toString());
        }

        protected static void appendStaticPropertyModifiersExceptRange(CompoundModifier modifier) {
            modifier.addModifier((AbstractModifier)((Modifier)new Modifier("LABEL").addParameter(new StringParameter("labelName"))).setRequired(false));
            modifier.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION").addParameter(new StringParameter("description"))).setRequired(false));
            modifier.addModifier((AbstractModifier)((Modifier)new Modifier("GROUP").addParameter(new StringParameter("groupName"))).setRequired(false));
            modifier.addModifier((AbstractModifier)new Modifier("REQUIRED").setRequired(false));
        }

        protected static void parseStaticPropertyModifiersExceptRange(StatementValueList line, ServiceConfigurationProperty property) {
            if (line.getParameter("labelName").isPresent()) {
                property.setLabel(line.getParameter("labelName").getValue());
            }
            if (line.getParameter("description").isPresent()) {
                property.setDescription(line.getParameter("description").getValue());
            }
            if (line.getParameter("groupName").isPresent()) {
                property.setGroup(line.getParameter("groupName").getValue());
            }
            if (line.getModifier("REQUIRED").isPresent()) {
                property.setRequired(true);
            }
        }

        protected static ServiceConfigurationProperty createProperty(StatementValueList line, PropertySyntax syntax) throws Exception {
            ServiceConfigurationProperty property = new AbstractServiceConfigurationObject().createProperty(line.getParameter("PropertyName").getValue(), syntax.getType(), null);
            property.setExportable(true);
            return property;
        }

        @Override
        public ServiceConfigurationProperty parse(StatementValueList line) throws Exception {
            ServiceConfigurationProperty property = AbstractPropertySyntax.createProperty(line, this);
            AbstractPropertySyntax.parseStaticPropertyModifiersExceptRange(line, property);
            this.parseRangeModifier(line, property);
            if (line.getParameter("DefaultValue").isPresent()) {
                property.setDefault(this.parsePropertyValue(line.getParameter("DefaultValue").getValue()));
            }
            return property;
        }
    }
}

