/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.mf.operation.service.AbstractLoadUnloadServiceOperation;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.sef.service.ServiceManagerException;
import java.util.List;

public class LoadServiceOperation
extends AbstractLoadUnloadServiceOperation {
    public static final String NAME = "load service";

    public LoadServiceOperation() {
        super(NAME);
        this.syntax.setDescription("Loads the specified service: loads service configuration (SCO), \ncreates service context and binds it to the Exchange.");
        this.syntax.setSyntaxDescription("If only a service type is specified, all service instances of that type will be unloaded.");
        this.syntax.setExamples("load service TestService.Service1\nload service TestService");
    }

    @Override
    protected AbstractServiceOperation.ServiceState getCompletionState() {
        return AbstractServiceOperation.ServiceState.NOT_LOADED;
    }

    @Override
    protected List<String> getServices(ServiceManager serviceManager) {
        return serviceManager.listRegisteredServices();
    }

    @Override
    protected String getOperationName() {
        return "Load";
    }

    @Override
    protected void doOperation(ServiceManager serviceManager, String serviceName) throws ServiceManagerException {
        serviceManager.loadServiceContext(serviceName);
    }
}

