/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AbstractListServicesDataspacesOperation;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.service.ServiceName;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class ListServicesOperation
extends AbstractListServicesDataspacesOperation {
    public static final String NAME = "list services";

    public ListServicesOperation() {
        super(NAME);
        this.syntax.addTag(OperationTag.service);
    }

    @Override
    protected String getEntityName() {
        return "service";
    }

    @Override
    protected String getTypeForExamples() {
        return "TestService";
    }

    @Override
    protected AbstractParameter createTypeParameter() {
        return new IdentifierParameter("Type");
    }

    @Override
    protected void fillResult(AbstractListServicesDataspacesOperation.Definition definition, MFSession session, Pattern pattern, RowSet result) throws Exception {
        RepositoryAccessor accessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        for (ServiceName service : this.listServices(definition.type)) {
            EventScope eventScope = accessor.loadServiceConfiguration(service.getName(), service.getType()).getEventScope();
            if (!this.isSuitable(service.getType(), service.getName(), eventScope, definition, session, pattern)) continue;
            result.addToRowSet(new Object[]{((RuntimeContext)this.callable).getName(), service.getType(), service.getName(), eventScope.toString(), AbstractServiceOperation.getServiceState(((RuntimeContext)this.callable).getServiceManager(), service.getFullName())});
        }
    }

    private Set<ServiceName> listServices(String type) throws Exception {
        TreeSet<ServiceName> result = new TreeSet<ServiceName>();
        if (type != null) {
            this.addServices(type, result);
        } else {
            for (String serviceType : ((RuntimeContext)this.callable).getRepositoryAccessor().listServiceTypes()) {
                this.addServices(serviceType, result);
            }
        }
        return result;
    }

    private void addServices(String type, Set<ServiceName> result) throws Exception {
        for (String name : ((RuntimeContext)this.callable).getRepositoryAccessor().listServicesByType(type)) {
            if (!ListServicesOperation.isActualService(name)) continue;
            result.add(new ServiceName(type, name));
        }
    }

    @Override
    protected boolean isSystem(String type, String name) {
        return ListServicesOperation.isSystemService(type, name);
    }

    public static boolean isSystemService(String type, String name) {
        return type.equals("RedSquareManager") || type.equals("RedSquareAgent");
    }

    private static boolean isActualService(String name) {
        return !name.equalsIgnoreCase("prototype");
    }
}

