/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ListServiceTypesOperation
extends AbstractServiceOperation {
    public static final String NAME = "list service types";

    public ListServiceTypesOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST SERVICE TYPES");
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Returns a list of service types.");
        this.syntax.setSyntaxDescription("list service types                     - Returns a list of service types in the current node.\nlist service types at node <NodeName>  - Returns a list of service types in the specified node.\nlist service types at domain           - Returns a list of service types in all nodes of the sysplex.");
        this.syntax.setExamples("list service types\nlist service types at node Node1\nlist service types at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        boolean atDomain = ((Definition)statement).nodeName != null && ((Definition)statement).nodeName.equals("*");
        RowSet result = new RowSet(ListServiceTypesOperation.createResultDescriptor(atDomain));
        for (String type : ((RuntimeContext)this.callable).getRepositoryAccessor().listServiceTypes()) {
            if (atDomain) {
                result.addToRowSet(new Object[]{((RuntimeContext)this.callable).getName(), type});
                continue;
            }
            result.addToRowSet(new Object[]{type});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor(boolean atDomain) {
        RowMetaData result = new RowMetaData();
        if (atDomain) {
            ListServiceTypesOperation.addColumn(result, "Node");
        }
        ListServiceTypesOperation.addColumn(result, "Type");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;

        public Definition(String nodeName) {
            super(ListServiceTypesOperation.NAME);
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

