/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.service.mf.impl.ListEventsOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;

public class ListServiceEventsOperation
extends AbstractServiceOperation {
    public static final String NAME = "list service events";

    public ListServiceEventsOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST SERVICE EVENTS");
        this.syntax.addModifier((AbstractModifier)new CompoundModifier().addModifier(new ChoiceModifier().addPossibleValue("AT").addPossibleValue("@")).addParameter(new AbstractServiceOperation.ServiceTypeNameParameter(AbstractServiceOperation.ServiceState.LOADED)).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("list service events       - Returns list of events in specified service.");
        this.syntax.setExamples("list service events at ExampleType.ExampleName");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ServiceType").getValue(), statement.getParameter("ServiceName").getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        try (FabricConnection connection = new FabricConnectionFactory().createConnection();){
            connection.open();
            ServiceAccessor serviceAccessor = connection.createServiceAccessor(definition.serviceType, definition.serviceName);
            if (!serviceAccessor.isAvailable() || !serviceAccessor.isOpened()) {
                throw new Exception("Specified service is not available.");
            }
            SLResponse sLResponse = ListEventsOperation.createSLResponse(serviceAccessor.listActiveEvents());
            return sLResponse;
        }
    }

    public static class Definition
    extends AbstractServiceOperation.Definition {
        public String serviceType;
        public String serviceName;

        public Definition(String serviceType, String serviceName) {
            super(ListServiceEventsOperation.NAME, serviceType + "." + serviceName);
            this.serviceType = serviceType;
            this.serviceName = serviceName;
        }
    }
}

