/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.Trace;
import com.streamscape.lib.loader.MemoryJarFile;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.runtime.mf.operation.edl.SdoUtils;
import com.streamscape.runtime.mf.operation.edl.generator.JavassistSdoCompiler;
import com.streamscape.runtime.mf.operation.edl.generator.SdoClass;
import com.streamscape.runtime.mf.operation.edl.generator.SdoConstructor;
import com.streamscape.runtime.mf.operation.edl.generator.SdoField;
import com.streamscape.runtime.mf.operation.edl.generator.SdoMethod;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.sys.Void;
import com.streamscape.sef.ErrorCodes;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.service.AbstractCancellableService;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.CancellableService;
import com.streamscape.service.osf.DaemonService;
import com.streamscape.service.osf.Service;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.FeedbackOperationInvoker;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import java.io.File;
import java.util.List;

public class GenerateServiceTypeOperation
extends AbstractServiceOperation {
    public static final String NAME = "generate service type";
    static final String GENERATED_COMMENT = "// TODO Auto-generated method stub\n";

    public GenerateServiceTypeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("GENERATE SERVICE TYPE").addActionParameter(new IdentifierParameter("ServiceType"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("ARCHIVE").addParameter(new IdentifierParameter("ArchiveName"))).setSyntaxHintSpace());
        this.syntax.addModifier(((CompoundModifier)new CompoundModifier(false).setSyntaxHintSpace()).addModifier(new Modifier("SOURCE")).addModifier(new ChoiceModifier().addPossibleValue("AT").addPossibleValue("@")).addParameter(new SLFilePathParameter("SourceDir")));
        this.syntax.addModifier((AbstractModifier)new Modifier("BUILD", false).setSyntaxHintSpace());
        this.syntax.addModifier(((CompoundModifier)new CompoundModifier("CompoundNative", false).setSyntaxHintSpace()).addModifier(new Modifier("NATIVE")).addModifier(new Modifier("ABSTRACT", false)));
        this.syntax.setDescription("Creates package service.<ServiceType> and adds archive with archive <ArchiveName> to created package.\nIf <SourceDir> directory specified service source file and package file will be stored at <SourceDir>/src and <SourceDir>/pkg.\nIf BUILD option specified service stub will be built and placed at in .tfcache/lib and at <SourceDir>/lib.\nService stub class implements Service, DaemonService or CancellableService interfaces.\nIf BUILD option specified service stub will be built and placed at in .tfcache/lib and at <SourceDir>/lib.");
        this.syntax.setSyntaxDescription("Mandatory parameters:\n\n  <ServiceType>         - Service type.\n  archive <ArchiveName> - Archive name where service class will be located.\n\nOptional parameters:\n\n  source at <SourceDir> - Creates service source stub, at <SourceDir>/src/<service class name>.java.\n  build                 - Builds service stub jar archive and places it at .tfcache/lib and at <SourceDir>/lib.\n  native                - Adds definition and initialization of runtime and service contexts to generated service class.\n  native abstract       - Generated service class extends abstract class (not interfaces).");
        this.syntax.setExamples("generate service type ExampleType archive Example source at 'c:\\' build");
        this.syntax.addCompletionCommand("list services");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        RepositoryAccessor repositoryAccessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        try {
            for (String type : repositoryAccessor.listServiceTypes()) {
                for (String name : repositoryAccessor.listServicesByType(type)) {
                    if (!name.equalsIgnoreCase("prototype")) continue;
                    completions.add(type);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = new Definition(statement.getParameter("ServiceType").getValue(), SdoUtils.makeArchiveName(statement.getParameter("ArchiveName").getValue()), statement.getParameter("SourceDir").isPresent() ? statement.getParameter("SourceDir").getValue() : null, statement.getModifier("BUILD").isPresent());
        definition.isNative = statement.getModifier("NATIVE").isPresent();
        definition.isNativeAbstract = statement.getModifier("ABSTRACT").isPresent();
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return new FeedbackOperationInvoker(){

            @Override
            protected SLResponse onInvoke(SLStatement statement, MFSession session) throws Exception {
                Package pkg;
                Definition definition = (Definition)statement;
                if (!ServiceConfigurationFactory.existsConfigurationObject("prototype", definition.serviceType)) {
                    throw new Exception("Service prototype does not exist.");
                }
                if (!definition.build && !((RuntimeContext)GenerateServiceTypeOperation.this.callable).getRepositoryAccessor().existsArchive(definition.archiveName)) {
                    throw new Exception("Creation of service package '" + Package.getFullName(PackageType.service, definition.serviceType) + "' failed. Cause: Service archive '" + definition.archiveName + "' does not exist.");
                }
                if (((RuntimeContext)GenerateServiceTypeOperation.this.callable).getRepositoryAccessor().existsPackage(PackageType.service, definition.serviceType) && !((RuntimeContext)GenerateServiceTypeOperation.this.callable).getRepositoryAccessor().getPackage(PackageType.service, definition.serviceType).containsJAR(definition.archiveName) && ((RuntimeContext)GenerateServiceTypeOperation.this.callable).getPackageManifestManager().isPackageLoaded(Package.getFullName(PackageType.service, definition.serviceType))) {
                    throw new Exception("Package " + Package.getFullName(PackageType.service, definition.serviceType) + " is loaded and cannot be changed.");
                }
                if (definition.sourceDir != null || definition.build) {
                    SdoClass serviceSource = GenerateServiceTypeOperation.this.generateServiceSource(definition.serviceType, definition.isNative, definition.isNativeAbstract);
                    if (definition.sourceDir != null) {
                        GenerateServiceTypeOperation.this.checkDirExistsOrCreate(session, definition.sourceDir, this);
                        GenerateServiceTypeOperation.this.createSourceFile(session, definition, serviceSource, this);
                    }
                    if (definition.build) {
                        if (((RuntimeContext)GenerateServiceTypeOperation.this.callable).getRepositoryAccessor().existsArchive(definition.archiveName)) {
                            throw new Exception("Archive '" + definition.archiveName + "' already exists in .tfcache/lib and cannot be replaced. Remove archive or specify another name.");
                        }
                        JavassistSdoCompiler compiler = new JavassistSdoCompiler(((RuntimeContext)GenerateServiceTypeOperation.this.callable).getSystemClassLoaderChain());
                        compiler.removeClass(serviceSource);
                        byte[] bytes = compiler.compile(serviceSource);
                        MemoryJarFile jarFile = new MemoryJarFile();
                        jarFile.addEntry(SdoUtils.getClassPathInJar(serviceSource.getFullClassName()), bytes);
                        jarFile.addEntry(SdoUtils.getSrcPathInJar(serviceSource.getFullClassName()), serviceSource.toString().getBytes());
                        byte[] jarBytes = jarFile.getJarBytes();
                        ((RuntimeContext)GenerateServiceTypeOperation.this.callable).getRepositoryAccessor().addArchive(definition.archiveName, jarBytes);
                        this.addFeedback("Archive '" + definition.archiveName + "' with service stub and source code created in .tfcache/lib.");
                        GenerateServiceTypeOperation.this.createArchiveFile(session, definition, jarBytes, this);
                    }
                }
                if (((RuntimeContext)GenerateServiceTypeOperation.this.callable).getRepositoryAccessor().existsPackage(PackageType.service, definition.serviceType)) {
                    pkg = ((RuntimeContext)GenerateServiceTypeOperation.this.callable).getRepositoryAccessor().getPackage(PackageType.service, definition.serviceType);
                    if (!pkg.containsJAR(definition.archiveName)) {
                        pkg.addJAR(definition.archiveName);
                        ((RuntimeContext)GenerateServiceTypeOperation.this.callable).getRepositoryAccessor().updatePackage(pkg);
                        this.addFeedback("Archive '" + definition.archiveName + "' added to package '" + pkg.getFullName() + "'.");
                    } else {
                        this.addFeedback("Package '" + pkg.getFullName() + "' already exists and contains archive '" + definition.archiveName + "'.");
                    }
                } else {
                    pkg = Package.create(PackageType.service, definition.serviceType, definition.archiveName);
                    ((RuntimeContext)GenerateServiceTypeOperation.this.callable).getRepositoryAccessor().addPackage(pkg);
                    this.addFeedback("Package '" + pkg.getFullName() + "' with archive '" + definition.archiveName + "' created.");
                }
                GenerateServiceTypeOperation.this.createPackgeFile(session, definition, pkg, this);
                return new SLResponse();
            }
        }.invoke(statement, session);
    }

    private void createSourceFile(MFSession session, Definition definition, SdoClass serviceSource, FeedbackOperationInvoker feedbackInvoker) throws Exception {
        this.createFile(session, definition, serviceSource.toString().getBytes(), serviceSource.getClassName() + ".java", "src" + File.separatorChar + serviceSource.getPackageName().replace('.', File.separatorChar), feedbackInvoker);
    }

    private void createArchiveFile(MFSession session, Definition definition, byte[] jarBytes, FeedbackOperationInvoker feedbackInvoker) throws Exception {
        this.createFile(session, definition, jarBytes, (String)(definition.archiveName.endsWith(".jar") ? definition.archiveName : definition.archiveName + ".jar"), "lib", feedbackInvoker);
    }

    private void createPackgeFile(MFSession session, Definition definition, Package pkg, FeedbackOperationInvoker feedbackInvoker) throws Exception {
        this.createFile(session, definition, ((RuntimeContext)this.callable).getXSerializer().serialize(pkg).getBytes(), pkg.getArtifactName(), "pkg", feedbackInvoker);
    }

    private void createFile(MFSession session, Definition definition, byte[] contentBytes, String filename, String dirName, FeedbackOperationInvoker feedbackInvoker) throws Exception {
        if (definition.sourceDir == null) {
            return;
        }
        String fullDirName = definition.sourceDir + "/" + dirName;
        this.checkDirExistsOrCreate(session, fullDirName, feedbackInvoker);
        filename = fullDirName + "/" + (String)filename;
        try {
            ((SLFileUtils)new SLFileUtilsFactory().create(session, (String)filename)).createFile(contentBytes, false);
        }
        catch (Exception exception) {
            throw new Exception("Failed to create file '" + (String)filename + "'. Cause: " + exception.toString());
        }
        if (feedbackInvoker != null) {
            feedbackInvoker.addFeedback("File '" + (String)filename + "' created.");
        }
    }

    private void checkDirExistsOrCreate(MFSession session, String directoryName, FeedbackOperationInvoker feedbackInvoker) throws Exception {
        SLFileUtils utils = (SLFileUtils)new SLFileUtilsFactory().create(session, directoryName);
        if (utils.supportsIsDirectoryOperation() && utils.supportsCreateDirectoryOperation()) {
            if (utils.isDirectory()) {
                return;
            }
            if (utils.exists()) {
                throw new Exception("Specified '" + directoryName + "' is not a directory.");
            }
            try {
                utils.createDirectory();
                if (feedbackInvoker != null) {
                    feedbackInvoker.addFeedback("Directory '" + directoryName + "' created.");
                }
            }
            catch (Exception exception) {
                throw new Exception("Failed to create directory '" + directoryName + "' failed. Cause: " + exception.toString());
            }
        }
    }

    private SdoClass generateServiceSource(String serviceType, boolean isNative, boolean isNativeAbstract) throws Exception {
        SdoMethod method;
        ServiceConfigurationObject sco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)this.callable, "prototype", serviceType, true);
        String className = sco.getServiceClassName();
        String packageName = "";
        if (className.lastIndexOf(46) != -1) {
            packageName = className.substring(0, className.lastIndexOf(46));
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        SdoClass sdo = new SdoClass(packageName, className);
        if (sco.isDaemonService()) {
            if (isNativeAbstract) {
                sdo.setSuperclass(AbstractDaemonService.class.getName());
                method = new SdoMethod("void", "doRepeatableServiceLogic");
                method.setModifier("protected");
                method.appendToBody(GENERATED_COMMENT);
                sdo.addMethod(method);
            } else {
                sdo.addInterface(DaemonService.class.getName());
                method = new SdoMethod("void", "run");
                method.setModifier("public");
                method.appendToBody(GENERATED_COMMENT);
                method.addThrowsException(ServiceFrameworkException.class.getName());
                sdo.addMethod(method);
            }
        }
        if (sco.isInterruptableService()) {
            if (isNativeAbstract && !sco.isDaemonService()) {
                sdo.setSuperclass(AbstractCancellableService.class.getName());
            } else {
                sdo.addInterface(CancellableService.class.getName());
            }
            method = new SdoMethod("void", "cancel");
            method.addThrowsException(ServiceFrameworkException.class.getName());
            method.appendToBody(GENERATED_COMMENT);
            sdo.addMethod(method);
        }
        if (!sco.isDaemonService() && !sco.isInterruptableService()) {
            if (isNativeAbstract) {
                sdo.setSuperclass(AbstractService.class.getName());
            } else {
                sdo.addInterface(Service.class.getName());
            }
        }
        sdo.addConstructor(new SdoConstructor(sdo));
        if (isNativeAbstract) {
            this.addAbstractServiceMethods(sdo);
        } else {
            this.addServiceMethods(sdo, isNative);
        }
        this.addVersionAndBuildServiceMethods(sdo);
        this.addHandlerMethods(sdo, sco);
        return sdo;
    }

    private void addVersionAndBuildServiceMethods(SdoClass sdo) {
        SdoMethod method = new SdoMethod("int", "getMajorVersion");
        method.appendToBody(GENERATED_COMMENT);
        method.appendToBody("return 1;");
        sdo.addMethod(method);
        method = new SdoMethod("int", "getMinorVersion");
        method.appendToBody(GENERATED_COMMENT);
        method.appendToBody("return 0;");
        sdo.addMethod(method);
        method = new SdoMethod("int", "getMajorBuild");
        method.appendToBody(GENERATED_COMMENT);
        method.appendToBody("return 1;");
        sdo.addMethod(method);
        method = new SdoMethod("int", "getMinorBuild");
        method.appendToBody(GENERATED_COMMENT);
        method.appendToBody("return 0;");
        sdo.addMethod(method);
        method = new SdoMethod("String", "getVersion");
        method.appendToBody(GENERATED_COMMENT);
        method.appendToBody("return \"Version 1.\";");
        sdo.addMethod(method);
    }

    private void addAbstractServiceMethods(SdoClass sdo) {
        SdoMethod method = new SdoMethod("void", "doInit");
        method.setModifier("protected");
        method.addThrowsException(ServiceFrameworkException.class.getName());
        method.appendToBody(GENERATED_COMMENT);
        sdo.addMethod(method);
    }

    private void addServiceMethods(SdoClass sdo, boolean withInit) {
        SdoMethod method = new SdoMethod("void", "init");
        method.setModifier("public");
        method.addThrowsException(ServiceFrameworkException.class.getName());
        method.appendToBody(GENERATED_COMMENT);
        if (withInit) {
            SdoField field = new SdoField(RuntimeContext.class.getName(), "context");
            field.setModifier("protected");
            field.setInitializer("null");
            sdo.addField(field);
            field = new SdoField(ServiceContext.class.getName(), "ctx");
            field.setModifier("protected");
            field.setInitializer("null");
            sdo.addField(field);
            field = new SdoField(ServiceConfigurationObject.class.getName(), "sco");
            field.setModifier("protected");
            field.setInitializer("null");
            sdo.addField(field);
            method.appendToBody("try\n{\n  context = " + RuntimeContext.class.getName() + ".getInstance();\n  ctx     = context.lookupServiceContext(this);\n  sco     = ctx.getServiceConfiguration();\n}\ncatch (" + ServiceFrameworkException.class.getName() + " exception)\n{\n  throw exception;\n}\ncatch (" + Exception.class.getName() + " exception)\n{\n  " + Trace.class.getName() + ".logException(this, exception, true);\n  throw new " + ServiceFrameworkException.class.getName() + "(" + ErrorCodes.class.getName() + ".SEF_SERVICE_INITIALIZATION_FAILED, exception);\n}\n");
        }
        sdo.addMethod(method);
        method = new SdoMethod("void", "destroy");
        method.setModifier("public");
        method.addThrowsException(ServiceFrameworkException.class.getName());
        method.appendToBody(GENERATED_COMMENT);
        sdo.addMethod(method);
        method = new SdoMethod("void", "start");
        method.setModifier("public");
        method.addThrowsException(ServiceFrameworkException.class.getName());
        method.appendToBody(GENERATED_COMMENT);
        sdo.addMethod(method);
        method = new SdoMethod("void", "stop");
        method.setModifier("public");
        method.addThrowsException(ServiceFrameworkException.class.getName());
        method.appendToBody(GENERATED_COMMENT);
        sdo.addMethod(method);
        method = new SdoMethod("void", "suspend");
        method.setModifier("public");
        method.addThrowsException(ServiceFrameworkException.class.getName());
        method.appendToBody(GENERATED_COMMENT);
        sdo.addMethod(method);
        method = new SdoMethod("void", "resume");
        method.setModifier("public");
        method.addThrowsException(ServiceFrameworkException.class.getName());
        method.appendToBody(GENERATED_COMMENT);
        sdo.addMethod(method);
    }

    private void addHandlerMethods(SdoClass sdo, ServiceConfigurationObject sco) throws Exception {
        for (EventHandler handler : sco.getEventHandlers()) {
            String exceptionText = "\"Method " + handler.getMethodName() + " not yet implemented.\"";
            String requestClassName = this.resolveSemanticType("Request", handler.getHandlerName(), handler.getRequestSemanticType());
            String responseClassName = this.resolveSemanticType("Response", handler.getHandlerName(), handler.getResponseSemanticType());
            if (responseClassName != null) {
                SdoMethod method = new SdoMethod(responseClassName, handler.getMethodName());
                if (requestClassName != null && !requestClassName.equals("void")) {
                    method.addArgument(requestClassName, "request");
                }
                method.appendToBody(GENERATED_COMMENT);
                if (responseClassName.endsWith(".String")) {
                    method.appendToBody("return new " + responseClassName + "(" + exceptionText + ");");
                } else {
                    method.appendToBody("throw new java.lang.RuntimeException(" + exceptionText + ");");
                }
                sdo.addMethod(method);
            }
            SdoMethod method = new SdoMethod(ImmutableEventDatagram.class.getName(), handler.getMethodName());
            method.addArgument(ImmutableEventDatagram.class.getName(), "event");
            method.appendToBody(GENERATED_COMMENT);
            method.appendToBody("throw new java.lang.RuntimeException(" + exceptionText + ");");
            sdo.addMethod(method);
        }
    }

    private String resolveSemanticType(String request, String handlerName, String typeName) throws Exception {
        if (typeName != null && typeName.length() > 0 && !typeName.equalsIgnoreCase("Null")) {
            typeName = this.resolveTypeName(typeName);
            SemanticType semanticType = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(typeName);
            if (semanticType == null) {
                throw new Exception(request + " semantic type " + typeName + " for handler " + handlerName + " does not exist.");
            }
            if (semanticType.getClassName().equals(Void.class.getName())) {
                return "void";
            }
            return semanticType.getClassName();
        }
        return null;
    }

    public static class Definition
    extends AbstractSLStatement {
        String serviceType;
        String archiveName;
        String sourceDir;
        boolean build = false;
        boolean createSourceFile = true;
        boolean isNative = false;
        boolean isNativeAbstract = false;

        public Definition(String serviceType, String archiveName, String sourceDir, boolean build) {
            super(GenerateServiceTypeOperation.NAME);
            this.serviceType = serviceType;
            this.archiveName = archiveName;
            this.sourceDir = sourceDir;
            this.build = build;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public String getArchiveName() {
            return this.archiveName;
        }

        public String getSourceDir() {
            return this.sourceDir;
        }

        public boolean isBuild() {
            return this.build;
        }

        public boolean isCreateSourceFile() {
            return this.createSourceFile;
        }
    }
}

