/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.operation.service.AbstractServiceTypeOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.FeedbackOperationInvoker;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.List;

public class DropServiceTypeOperation
extends AbstractServiceTypeOperation {
    public static final String NAME = "drop service type";

    public DropServiceTypeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP SERVICE TYPE").addActionParameter(new IdentifierParameter("ServiceType"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("ARCHIVES").addParameter(new SetParameter("ArchivesSet", new IdentifierParameter("Archive")))).setRequired(false));
        this.syntax.setDescription("Drops a service prototype, service type package and archives.");
        this.syntax.setSyntaxDescription("drop service type <TypeName>                     - drops service prototype and package without archives.\ndrop service type <TypeName> archives(all)       - drops service prototype and package with archives.\ndrop service type <TypeName> archives(<archive>) - drops service prototype, package with archives and specified archives.\n");
        this.syntax.setExamples("drop service type ExampleType");
        this.syntax.addCompletionCommand("list services");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.getServicesPrototypes(completions);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        ArrayList<String> archives = null;
        boolean allArchives = false;
        StatementSetValue archivesSet = statement.getSet("ArchivesSet");
        if (archivesSet.isPresent()) {
            archives = new ArrayList<String>();
            for (int i = 0; i < archivesSet.size(); ++i) {
                StatementValueList archiveValue = archivesSet.getElement(i);
                archives.add(archiveValue.getParameter("Archive").getValue());
            }
            if (archives.size() == 1 && ((String)archives.get(0)).equalsIgnoreCase("all")) {
                allArchives = true;
                archives = null;
            }
        }
        return new Definition(statement.getParameter("ServiceType").getValue(), archives, allArchives);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return new FeedbackOperationInvoker(){

            @Override
            protected SLResponse onInvoke(SLStatement statement, MFSession session) throws Exception {
                Definition definition = (Definition)statement;
                if (!ServiceConfigurationFactory.existsServicePrototype(definition.serviceType)) {
                    throw new Exception("Service prototype does not exist.");
                }
                if (ServiceConfigurationFactory.existsServiceInstances(definition.serviceType)) {
                    throw new Exception("Cannot drop service type while exist service instances.");
                }
                String packageName = String.valueOf((Object)PackageType.service) + "." + definition.serviceType;
                if (((RuntimeContext)DropServiceTypeOperation.this.callable).getRepositoryAccessor().existsPackage(PackageType.service, definition.serviceType)) {
                    Package pkg = ((RuntimeContext)DropServiceTypeOperation.this.callable).getRepositoryAccessor().getPackage(PackageType.service, definition.serviceType);
                    ((RuntimeContext)DropServiceTypeOperation.this.callable).getRepositoryAccessor().removePackage(PackageType.service, definition.serviceType, definition.allArchives);
                    this.addFeedback("Package '" + packageName + "' removed.");
                    if (definition.allArchives) {
                        for (String archive : pkg.listJARs()) {
                            this.addFeedback("Archive '" + archive + "' removed.");
                        }
                    }
                }
                if (definition.archives != null) {
                    for (String archive : definition.archives) {
                        if (((RuntimeContext)DropServiceTypeOperation.this.callable).getRepositoryAccessor().existsArchive(archive)) {
                            Package pkg = ((RuntimeContext)DropServiceTypeOperation.this.callable).getRepositoryAccessor().getPackageByArchive(archive);
                            if (pkg != null) {
                                this.addFeedback("Archive '" + archive + "' contained in package '" + pkg.getFullName() + "' and cannot be removed.");
                                continue;
                            }
                            ((RuntimeContext)DropServiceTypeOperation.this.callable).getRepositoryAccessor().removeArchive(archive);
                            this.addFeedback("Archive '" + archive + "' removed.");
                            continue;
                        }
                        this.addFeedback("Archive '" + archive + "' does not exist.");
                    }
                }
                ServiceConfigurationFactory.removeConfigurationObject("prototype", definition.serviceType);
                this.addFeedback("Service type dropped.");
                return new SLResponse();
            }
        }.invoke(statement, session);
    }

    public static class Definition
    extends AbstractSLStatement {
        String serviceType;
        List<String> archives;
        boolean allArchives;

        Definition(String serviceType, List<String> archives, boolean allArchives) {
            super(DropServiceTypeOperation.NAME);
            this.serviceType = serviceType;
            this.archives = archives;
            this.allArchives = allArchives;
        }
    }
}

