/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.operation.pkg.AbstractServicePackageOperation;
import com.streamscape.runtime.mf.operation.service.AbstractServiceTypeOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.pkg.ComponentPackageManifest;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.FeedbackOperationInvoker;
import java.util.List;

public class DropServiceInstanceOperation
extends AbstractServiceTypeOperation {
    public static final String NAME = "drop service instance";

    public DropServiceInstanceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP SERVICE INSTANCE").addActionParameter(new AbstractServiceOperation.ServiceTypeNameParameter(AbstractServiceOperation.ServiceState.ALL));
        this.syntax.setDescription("Drops a service instance and unregisters service package.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ServiceType").getValue(), statement.getParameter("ServiceName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return new FeedbackOperationInvoker(){

            @Override
            protected SLResponse onInvoke(SLStatement statement, MFSession session) throws Exception {
                Definition definition = (Definition)statement;
                if (definition.serviceName.equalsIgnoreCase("prototype")) {
                    throw new Exception("Cannot drop service prototype. Use drop service type operation.");
                }
                if (!ServiceConfigurationFactory.existsConfigurationObject(definition.serviceName, definition.serviceType)) {
                    throw new Exception("Service instance doesn't exist.");
                }
                String serviceFullName = definition.serviceType + "." + definition.serviceName;
                if (((RuntimeContext)DropServiceInstanceOperation.this.callable).getServiceManager().listRunningServices().contains(serviceFullName)) {
                    throw new Exception("Cannot drop running service instance, stop it first.");
                }
                if (((RuntimeContext)DropServiceInstanceOperation.this.callable).getServiceManager().isServiceRegistered(serviceFullName)) {
                    throw new Exception("Cannot drop registered service instance, unregister it first.");
                }
                ComponentPackageManifest manifest = AbstractServicePackageOperation.loadManifest((FabricComponent)DropServiceInstanceOperation.this.callable, definition.serviceType, definition.serviceName);
                if (manifest != null) {
                    List<String> packages = manifest.listPackages();
                    manifest.clear();
                    AbstractServicePackageOperation.saveManifest((FabricComponent)DropServiceInstanceOperation.this.callable, manifest, definition.serviceType, definition.serviceName);
                    for (String pkg : packages) {
                        this.addFeedback("Service package '" + pkg + "' unregistered.");
                    }
                }
                ServiceConfigurationFactory.removeConfigurationObject(definition.serviceName, definition.serviceType);
                this.addFeedback("Service instance dropped.");
                return new SLResponse();
            }
        }.invoke(statement, session);
    }

    static class Definition
    extends AbstractSLStatement {
        String serviceType;
        String serviceName;

        Definition(String serviceType, String serviceName) {
            super(DropServiceInstanceOperation.NAME);
            this.serviceType = serviceType;
            this.serviceName = serviceName;
        }
    }
}

