/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.Trace;
import com.streamscape.Version;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.service.osf.config.AbstractFactoryPropertyValue;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.JDBCFactoryPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.TransportFactoryPropertyValue;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class DescribeServiceOperation
extends AbstractServiceOperation {
    public static final String NAME = "describe service";

    public DescribeServiceOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE SERVICE");
        this.syntax.addActionParameter((SyntaxParameter)((ExpressionParameter)new ExpressionParameter("ServiceFullName").setCompactSyntax("[NodeName://]<ServiceType>.<ServiceName>")).setEndDelimiterToCommandEnd());
        this.syntax.setDescription("Shows information about the specified service.");
        this.syntax.setExamples("describe service TestService.Service1\ndescribe service Node1://TestService.Service1 ");
        this.syntax.addCompletionCommand("list services at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ServiceFullName").getValue());
    }

    @Override
    protected void doInternalParseCompletionResponse(SLResponse response, List<String> completions) {
        DescribeServiceOperation.parseListServicesCompletionResponse(response, completions, (RuntimeContext)this.callable);
    }

    public static void parseListServicesCompletionResponse(SLResponse response, List<String> completions, RuntimeContext context) {
        RowSet rowSet = response.getRowSet();
        if (response.getRowSet() == null) {
            return;
        }
        try {
            while (rowSet.next()) {
                Object serviceName = "";
                String nodeName = rowSet.getString(1);
                if (!context.getName().equals(nodeName)) {
                    serviceName = nodeName + "://";
                }
                serviceName = (String)serviceName + rowSet.getString(2) + ".";
                serviceName = (String)serviceName + rowSet.getString(3);
                completions.add((String)serviceName);
            }
        }
        catch (Exception exception) {
            Trace.logException(DescribeServiceOperation.class, exception, false);
        }
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        String nodeName = this.getNodeName(((Definition)statement).getServiceName());
        return this.invoke(nodeName, statement, session, timeout, false, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        String serviceName = this.getServiceName(((Definition)statement).getServiceName());
        ServiceConfigurationObject sco = this.getSco(serviceName);
        ServiceDescriptor service = ((RuntimeContext)this.callable).getServiceManager().getService(serviceName);
        RowSet result = new RowSet(DescribeServiceOperation.createResultDescriptor());
        DescribeServiceOperation.addValues(result, "Node Name", node.getName());
        DescribeServiceOperation.addValues(result, "Service Type", sco.getServiceType());
        DescribeServiceOperation.addValues(result, "Service Name", sco.getServiceName());
        DescribeServiceOperation.addValues(result, "Invoke Mode", sco.getInvokeMode().toString());
        DescribeServiceOperation.addValues(result, "Event Scope", sco.getEventScope().toString());
        DescribeServiceOperation.addValues(result, "Packages", this.getServicePackages(sco));
        DescribeServiceOperation.addValues(result, "Package Dependencies", this.getPackageDependencies(sco));
        DescribeServiceOperation.addValues(result, "Description", sco.getServiceDescription());
        DescribeServiceOperation.addValues(result, "Version", DescribeServiceOperation.getServiceVersion(this.getServiceContext(service), sco, ((RuntimeContext)this.callable).getSystemClassLoaderChain()));
        DescribeServiceOperation.addValues(result, "State", this.getServiceState(serviceName));
        DescribeServiceOperation.addValues(result, "Autostart", service != null ? Boolean.valueOf(service.isAutostart()) : "n/a");
        DescribeServiceOperation.addValues(result, "Depends On", service != null ? service.getDependencies() : "n/a");
        DescribeServiceOperation.addValues(result, "Run As", service != null ? this.resolveCredentials(service.getCredentials()) : "n/a");
        DescribeServiceOperation.addValues(result, "Log Level", service != null ? service.getLogLevel().name() : "n/a");
        DescribeServiceOperation.addValues(result, "Log Broadcast", service != null ? Boolean.valueOf(service.getLogBroadcast()) : "n/a");
        DescribeServiceOperation.addValues(result, "Last Modified On", DescribeServiceOperation.formatDate(sco.getTimestamp()));
        DescribeServiceOperation.addValues(result, "Last Error", service != null ? DescribeServiceOperation.skipNull(service.getLastError()) : "n/a");
        return new SLResponse(result);
    }

    private List<String> getPackageDependencies(ServiceConfigurationObject sco) throws Exception {
        RepositoryAccessor accessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (accessor.existsPackage(PackageType.service, sco.getServiceType())) {
            return accessor.getPackage(PackageType.service, sco.getServiceType()).listDependencies();
        }
        return new ArrayList<String>();
    }

    private List<String> getServicePackages(ServiceConfigurationObject sco) throws Exception {
        RepositoryAccessor accessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        ArrayList<String> packages = new ArrayList<String>();
        if (accessor.existsPackage(PackageType.service, sco.getServiceType())) {
            packages.add(String.valueOf((Object)PackageType.service) + "." + sco.getServiceType());
        }
        for (ServiceConfigurationProperty prop : sco.getProperties()) {
            switch (prop.getType()) {
                case JDBC_FACTORY: {
                    AbstractFactoryPropertyValue value = (JDBCFactoryPropertyValue)prop.getValue();
                    if (value == null || !accessor.existsPackage(PackageType.jdbc, value.getFactoryType())) break;
                    packages.add(String.valueOf((Object)PackageType.jdbc) + "." + value.getFactoryType());
                    break;
                }
                case CLIENT_FACTORY: {
                    AbstractFactoryPropertyValue value = (ClientFactoryPropertyValue)prop.getValue();
                    if (value == null || !accessor.existsPackage(PackageType.client, value.getFactoryType())) break;
                    packages.add(String.valueOf((Object)PackageType.client) + "." + value.getFactoryType());
                    break;
                }
                case TRANSPORT_FACTORY: {
                    AbstractFactoryPropertyValue value = (TransportFactoryPropertyValue)prop.getValue();
                    if (value == null || !accessor.existsPackage(PackageType.transport, value.getFactoryType())) break;
                    packages.add(String.valueOf((Object)PackageType.transport) + "." + value.getFactoryType());
                    break;
                }
            }
        }
        return packages;
    }

    public static String getServiceVersion(ServiceContext service, ServiceConfigurationObject sco, ClassLoader systemLoader) {
        Object result;
        Object object = result = service != null ? service.getVersion() : null;
        if (result == null) {
            String serviceClassName = sco.getServiceClassName();
            String versionClassName = serviceClassName.substring(0, serviceClassName.lastIndexOf(".")) + ".Version";
            try {
                Class versionClass = ClassUtils.loadClass(versionClassName, systemLoader);
                int majorVersion = DescribeServiceOperation.invokeMethod(versionClass, versionClass.getSuperclass(), "getMajorVersion");
                int minorVersion = DescribeServiceOperation.invokeMethod(versionClass, versionClass.getSuperclass(), "getMinorVersion");
                int build = DescribeServiceOperation.invokeMethod(versionClass, versionClass.getSuperclass(), "getBuild");
                if (majorVersion >= 0 && minorVersion >= 0 && build >= 0) {
                    result = majorVersion + "." + minorVersion + " b" + build;
                }
                if (result == null) {
                    majorVersion = DescribeServiceOperation.invokeMethod(versionClass, versionClass.getSuperclass(), "getServiceMajorVersion");
                    minorVersion = DescribeServiceOperation.invokeMethod(versionClass, versionClass.getSuperclass(), "getServiceMinorVersion");
                    int majorBuild = DescribeServiceOperation.invokeMethod(versionClass, versionClass.getSuperclass(), "getRuntimeMajorBuild");
                    int minorBuild = DescribeServiceOperation.invokeMethod(versionClass, versionClass.getSuperclass(), "getRuntimeMinorBuild");
                    if (majorVersion >= 0 && minorVersion >= 0 && majorBuild >= 0 && minorBuild >= 0) {
                        result = Version.formatVersionWithBuild(majorVersion, minorVersion, majorBuild, minorBuild);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result != null ? result : "n/a";
    }

    private static int invokeMethod(Class versionClass, Class versionParentClass, String methodName) {
        try {
            Method method = DescribeServiceOperation.getMethod(versionClass, methodName);
            if (method == null) {
                method = DescribeServiceOperation.getMethod(versionParentClass, methodName);
            }
            return method != null ? (Integer)method.invoke(null, new Object[0]) : -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static Method getMethod(Class cls, String methodName) {
        try {
            return cls != null ? cls.getDeclaredMethod(methodName, new Class[0]) : null;
        }
        catch (NoSuchMethodException exception) {
            return null;
        }
    }

    private String resolveCredentials(byte[] credentials) {
        if (credentials == null) {
            return "RUNTIME";
        }
        try {
            Class<?> clazz = Class.forName("com.streamscape.sef.dispatcher.ServiceManagerImpl");
            Method method = clazz.getDeclaredMethod("resolveUserFromCredentials", byte[].class);
            method.setAccessible(true);
            Pair result = (Pair)method.invoke((Object)((RuntimeContext)this.callable).getServiceManager(), new Object[]{credentials});
            return (String)result.second;
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Unable to extract credentials.");
            return "Unknown";
        }
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeServiceOperation.addColumn(result, "Property");
        DescribeServiceOperation.addColumn(result, "Value");
        return result;
    }

    public static class Definition
    extends AbstractServiceOperation.Definition {
        public Definition(String serviceName) {
            super(DescribeServiceOperation.NAME, serviceName);
        }
    }
}

