/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceName;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.List;

public class DescribeServiceManifestOperation
extends AbstractServiceOperation {
    public static final String NAME = "describe service manifest";

    public DescribeServiceManifestOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE SERVICE MANIFEST");
        this.syntax.setDescription("Shows a list of services registered in Service Manager.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(DescribeServiceManifestOperation.createResultDescriptor());
        for (String serviceName : ((RuntimeContext)this.callable).getServiceManager().listRegisteredServices()) {
            ServiceName name = new ServiceName(serviceName);
            ServiceDescriptor descriptor = ((RuntimeContext)this.callable).getServiceManager().getService(serviceName);
            result.addToRowSet(new Object[]{name.getType(), name.getName(), descriptor.isAutostart(), descriptor.getLogLevel(), this.getDependencies(descriptor)});
        }
        return new SLResponse(result);
    }

    protected String getDependencies(ServiceDescriptor service) {
        StringBuilder buffer = new StringBuilder();
        List<String> depends = service.getDependencies();
        if (depends != null) {
            boolean first = true;
            for (String depend : depends) {
                if (!first) {
                    buffer.append(",");
                    buffer.append(depend);
                    continue;
                }
                buffer.append(depend);
            }
        }
        return buffer.toString();
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        DescribeServiceManifestOperation.addColumn(result, "Service Type");
        DescribeServiceManifestOperation.addColumn(result, "Service Name");
        DescribeServiceManifestOperation.addColumn(result, "Autostart");
        DescribeServiceManifestOperation.addColumn(result, "Log Level");
        DescribeServiceManifestOperation.addColumn(result, "Dependencies");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(DescribeServiceManifestOperation.NAME);
        }
    }
}

