/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.runtime.mf.operation.service.AbstractServiceTypeOperation;
import com.streamscape.runtime.mf.operation.service.ServiceHandlersSyntax;
import com.streamscape.runtime.mf.operation.service.ServicePropertiesSyntax;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.osf.config.ServiceConfigurationProperties;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class CreateServiceTypeOperation
extends AbstractServiceTypeOperation {
    public static final String NAME = "create service type";

    public CreateServiceTypeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE SERVICE TYPE").addActionParameter(new IdentifierParameter("ServiceType"));
        this.appendCreateAlterServiceCommonParameters(this.syntax);
        this.syntax.addModifier(ServicePropertiesSyntax.createServicePropertiesCreateSyntax());
        this.syntax.addModifier(ServiceHandlersSyntax.createServiceHandlersCreateSyntax());
        this.syntax.setDescription("Creates a prototype for new service type with specified service parameters, properties and event handlers.\nSco <ServiceType>.prototype.sco will be created. Service prototype cannot be registered and started.\nTo register and start service service instance should be created using command 'create service instance'.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        String serviceType = statement.getParameter("ServiceType").getValue();
        if (ServiceConfigurationFactory.existsConfigurationObject("prototype", serviceType)) {
            throw new Exception("Service prototype already exists.");
        }
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)this.callable, "prototype", serviceType, false);
        this.parseCreateAlterServiceCommonParameters(sco, statement);
        ServicePropertiesSyntax.parseServiceProperties((ServiceConfigurationProperties)sco, statement);
        ServiceHandlersSyntax.parseServiceHandlers(sco, statement);
        ((RuntimeContext)this.callable).getRepositoryAccessor().saveServiceConfiguration(sco);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        Definition(DSLStatement statement) {
            super(CreateServiceTypeOperation.NAME);
            this.statement = statement;
        }
    }
}

