/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.repository.enums.PackageType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.runtime.mf.operation.pkg.AbstractServicePackageOperation;
import com.streamscape.runtime.mf.operation.service.AbstractServiceTypeOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.pkg.ComponentPackageManifest;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.FeedbackOperationInvoker;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;

public class CreateServiceInstanceOperation
extends AbstractServiceTypeOperation {
    public static final String NAME = "create service instance";

    public CreateServiceInstanceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE SERVICE INSTANCE").addActionParameter(new AbstractServiceOperation.ServiceTypeNameParameter(AbstractServiceOperation.ServiceState.PROTOTYPES)).addModifier((AbstractModifier)((Modifier)new Modifier("WITH SERVICE PACKAGE REGISTER").setName("withServicePackageRegister")).setRequired(false));
        this.syntax.setDescription("Creates a service instance based on service prototype.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ServiceType").getValue(), statement.getParameter("ServiceName").getValue(), statement.existsModifier("withServicePackageRegister"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return new FeedbackOperationInvoker(){

            @Override
            protected SLResponse onInvoke(SLStatement statement, MFSession session) throws Exception {
                Definition definition = (Definition)statement;
                if (definition.serviceName.equalsIgnoreCase("prototype")) {
                    throw new Exception("Service name cannot be 'prototype'.");
                }
                if (!ServiceConfigurationFactory.existsConfigurationObject("prototype", definition.serviceType)) {
                    throw new Exception("Service prototype does not exist.");
                }
                if (ServiceConfigurationFactory.existsConfigurationObject(definition.serviceName, definition.serviceType)) {
                    throw new Exception("Service instance already exists.");
                }
                if (definition.withServicePackageRegister && !((RuntimeContext)CreateServiceInstanceOperation.this.callable).getRepositoryAccessor().existsPackage(PackageType.service, definition.serviceType)) {
                    throw new Exception("Service package '" + String.valueOf((Object)PackageType.service) + "." + definition.serviceType + "' does not exist.");
                }
                ServiceConfigurationObject sco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)CreateServiceInstanceOperation.this.callable, "prototype", definition.serviceType, true);
                sco.setServiceName(definition.serviceName);
                ServiceConfigurationFactory.saveConfigurationObject(sco);
                this.addFeedback("Service instance created.");
                if (definition.withServicePackageRegister) {
                    ComponentPackageManifest manifest = AbstractServicePackageOperation.loadManifest((FabricComponent)CreateServiceInstanceOperation.this.callable, definition.serviceType, definition.serviceName);
                    if (manifest == null) {
                        manifest = new ComponentPackageManifest();
                    }
                    manifest.add(PackageDescriptor.create(((RuntimeContext)CreateServiceInstanceOperation.this.callable).getRepositoryAccessor().getPackage(PackageType.service, definition.serviceType), true));
                    AbstractServicePackageOperation.saveManifest((FabricComponent)CreateServiceInstanceOperation.this.callable, manifest, definition.serviceType, definition.serviceName);
                    this.addFeedback("Service package 'service." + definition.serviceType + "' registered.");
                }
                return new SLResponse();
            }
        }.invoke(statement, session);
    }

    static class Definition
    extends AbstractSLStatement {
        String serviceType;
        String serviceName;
        boolean withServicePackageRegister;

        Definition(String serviceType, String serviceName, boolean withServicePackageRegister) {
            super(CreateServiceInstanceOperation.NAME);
            this.serviceType = serviceType;
            this.serviceName = serviceName;
            this.withServicePackageRegister = withServicePackageRegister;
        }
    }
}

