/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class CloneServiceOperation
extends AbstractServiceOperation {
    public static String NAME = "clone service";

    public CloneServiceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CLONE SERVICE").addActionParameter(new AbstractServiceOperation.ServiceTypeNameParameter(AbstractServiceOperation.ServiceState.ALL));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("WITH NAME").addParameter(new IdentifierParameter("new name"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Clones existing service.\n\nNOTE: New service will have the same handlers and event IDs.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ServiceType").getValue(), statement.getParameter("ServiceName").getValue(), statement.getParameter("new name").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        String serviceFullName = definition.serviceType + "." + definition.serviceName;
        String serviceFullNameNew = definition.serviceType + "." + definition.newServiceName;
        if (!ServiceConfigurationFactory.existsConfigurationObject(definition.serviceName, definition.serviceType)) {
            throw new Exception("Service " + serviceFullName + " does not exist.");
        }
        if (ServiceConfigurationFactory.existsConfigurationObject(definition.newServiceName, definition.serviceType)) {
            throw new Exception("Service " + serviceFullNameNew + " already exists.");
        }
        ServiceConfigurationObject sco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)this.callable, definition.serviceName, definition.serviceType, true);
        SLOperationLogger.log(this, "\nSaving SCO for service " + serviceFullNameNew + "...\n");
        sco.setServiceName(definition.newServiceName);
        ServiceConfigurationFactory.saveConfigurationObject(sco);
        ServiceManager serviceManager = ((RuntimeContext)this.callable).getServiceManager();
        if (serviceManager.isServiceRegistered(serviceFullName)) {
            SLOperationLogger.log(this, "Registering service " + serviceFullNameNew + "...\n");
            ServiceDescriptor serviceDescriptor = serviceManager.getService(serviceFullName);
            ServiceDescriptor serviceDescriptorNew = new ServiceDescriptor(serviceFullNameNew);
            serviceDescriptorNew.setAutostart(serviceDescriptor.isAutostart());
            serviceDescriptorNew.setCredentials(serviceDescriptor.getCredentials());
            serviceDescriptorNew.setLogBroadcast(serviceDescriptor.getLogBroadcast());
            serviceDescriptorNew.setLogLevel(serviceDescriptor.getLogLevel());
            serviceDescriptorNew.setDependencies(serviceDescriptor.getDependencies());
            serviceManager.registerService(serviceDescriptorNew);
        }
        SLOperationLogger.log(this, "Cloned service " + serviceFullNameNew + " created.\n");
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        String serviceType;
        String serviceName;
        String newServiceName;

        Definition(String serviceType, String serviceName, String newServiceName) {
            super(NAME);
            this.serviceType = serviceType;
            this.serviceName = serviceName;
            this.newServiceName = newServiceName;
        }
    }
}

