/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.runtime.mf.operation.service.AbstractServiceTypeOperation;
import com.streamscape.runtime.mf.operation.service.ServiceHandlersSyntax;
import com.streamscape.runtime.mf.operation.service.ServicePropertiesSyntax;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.osf.config.ServiceConfigurationProperties;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import java.util.List;

public class AlterServiceTypeOperation
extends AbstractServiceTypeOperation {
    public static final String NAME = "alter service type";

    public AlterServiceTypeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER SERVICE TYPE").addActionParameter(new IdentifierParameter("ServiceType"));
        this.appendCreateAlterServiceCommonParameters(this.syntax);
        this.syntax.getModifier("CLASS").setRequired(false);
        this.syntax.addModifier(this.createRemovePropertySyntax());
        this.syntax.addModifier(ServicePropertiesSyntax.createServicePropertiesAlterSyntax(true));
        this.syntax.addModifier(this.createRemoveHandlerSyntax());
        this.syntax.addModifier(ServiceHandlersSyntax.createServiceHandlersAlterSyntax());
        this.syntax.setDescription("Modifies a service prototype.");
        this.syntax.addCompletionCommand("list services");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.getServicesPrototypes(completions);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        String serviceType = statement.getParameter("ServiceType").getValue();
        if (!ServiceConfigurationFactory.existsConfigurationObject("prototype", serviceType)) {
            throw new Exception("Service prototype does not exist.");
        }
        ServiceConfigurationObject sco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)this.callable, "prototype", serviceType, false);
        this.parseCreateAlterServiceCommonParameters(sco, statement);
        this.parseRemoveProperty(sco, statement);
        ServicePropertiesSyntax.parseServiceProperties((ServiceConfigurationProperties)sco, statement);
        this.parseRemoveHandler(sco, statement);
        ServiceHandlersSyntax.parseServiceHandlers(sco, statement);
        ((RuntimeContext)this.callable).getRepositoryAccessor().saveServiceConfiguration(sco);
        return new SLResponse();
    }

    private AbstractModifier<?> createRemovePropertySyntax() {
        return this.createNamesListSyntax("REMOVE PROPERTY", "propertyName");
    }

    private void parseRemoveProperty(final ServiceConfigurationObject sco, DSLStatement statement) throws Exception {
        this.parseServicePropertyNames("propertyName", statement, new NameObserver(){

            @Override
            public void onName(String name) throws Exception {
                sco.removeProperty(name);
            }
        });
    }

    private AbstractModifier<?> createRemoveHandlerSyntax() {
        return this.createNamesListSyntax("REMOVE HANDLER", "handlerName");
    }

    private void parseRemoveHandler(final ServiceConfigurationObject sco, DSLStatement statement) throws Exception {
        this.parseServicePropertyNames("handlerName", statement, new NameObserver(){

            @Override
            public void onName(String name) throws Exception {
                sco.removeEventHandler(name);
            }
        });
    }

    private AbstractModifier<?> createNamesListSyntax(String token, String elementName) throws RuntimeException {
        return (AbstractModifier)((BlockModifier)((BlockModifier)new BlockModifier(token, elementName + "Block").setSyntaxHint(new SyntaxHint(" ", true))).setRequired(false)).addModifier((AbstractModifier)new RepeatableModifier(elementName + "line").addParameter(new IdentifierParameter(elementName))).setCompactSyntax("[" + token.toLowerCase() + "(<" + elementName + ">, ...)]");
    }

    private void parseServicePropertyNames(String elementName, DSLStatement statement, NameObserver observer) throws Exception {
        if (statement.getBlock(elementName + "Block").isPresent()) {
            StatementBlockValue block = statement.getBlock(elementName + "Block");
            for (int i = 0; i < block.getLinesCount(); ++i) {
                observer.onName(block.getLineByIndex(i).getParameter(elementName).getValue());
            }
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        Definition(DSLStatement statement) {
            super(AlterServiceTypeOperation.NAME);
            this.statement = statement;
        }
    }

    public static interface NameObserver {
        public void onName(String var1) throws Exception;
    }
}

