/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class AlterServiceOperation
extends AbstractServiceOperation {
    public static final String NAME = "alter service";

    public AlterServiceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER SERVICE").addActionParameter(new AbstractServiceOperation.ServiceTypeNameParameter(AbstractServiceOperation.ServiceState.REGISTERED));
        this.syntax.addModifier(new AbstractServiceOperation.ServiceAutostartParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServiceSequenceParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServicePrincipalParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServicePasswordParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServiceLogLevelParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServiceLogBroadcastParameter());
        this.syntax.addModifier(new AbstractServiceOperation.ServiceDependsOnParameter(AbstractServiceOperation.ServiceState.REGISTERED));
        this.syntax.setDescription("Alters the specified service in the Service Manager.");
        this.syntax.setExamples("alter service ExampleType.ExampleName sequence 1\nalter service ExampleType.ExampleName autostart true\nalter service ExampleType.ExampleName autostart true log_level info depends on (Type1.Name1, Type2.Name2)");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parseManifestSyntax(statement, null);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ServiceManager serviceManager = ((RuntimeContext)this.callable).getServiceManager();
        boolean updated = false;
        ServiceDescriptor service = serviceManager.getService(definition.getServiceName());
        if (definition.autostart != null) {
            service.setAutostart(definition.isAutostart());
            updated = true;
        }
        if (definition.getDependencies() != null) {
            service.clearDependencies();
            for (String dependency : definition.getDependencies()) {
                service.addDependency(dependency);
            }
            updated = true;
        }
        if (updated) {
            serviceManager.updateService(service);
        }
        if (definition.getLogLevel() != null) {
            serviceManager.setServiceLogLevel(definition.getServiceName(), definition.getLogLevel());
        }
        if (definition.logBroadcast != null) {
            serviceManager.setServiceLogBroadcast(definition.getServiceName(), definition.isLogBroadcast());
        }
        if (definition.getPrincipal() != null) {
            serviceManager.runServiceAs(definition.getServiceName(), definition.getPrincipal(), definition.getPassword());
        }
        if (definition.getSequence() != -1) {
            serviceManager.setServiceSequence(definition.getServiceName(), definition.getSequence());
        }
        return new SLResponse();
    }

    @Override
    protected AbstractServiceOperation.ManifestDefinition createManifestDefinition(String serviceTypeName) {
        return new Definition(serviceTypeName);
    }

    public static class Definition
    extends AbstractServiceOperation.ManifestDefinition {
        public Definition(String serviceName) {
            super(AlterServiceOperation.NAME, serviceName);
        }
    }
}

