/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractServiceOperation;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.sef.service.ServiceManagerException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

abstract class AbstractLoadUnloadServiceOperation
extends AbstractServiceOperation {
    public AbstractLoadUnloadServiceOperation(String operationName) {
        this.createDSLSyntax(operationName);
        this.syntax.setAction(operationName).addActionParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter("ServiceName").setCompactSyntax("<ServiceType>[.<ServiceName>]")).setCompletionAdviser(new ServiceCompletionAdviser(this.getCompletionState())));
    }

    protected abstract AbstractServiceOperation.ServiceState getCompletionState();

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = new Definition(this.getName(), statement.getParameter("ServiceName").getValue());
        List<String> tokens = StringUtils.split(definition.serviceName, ".");
        if (tokens.size() > 2) {
            throw new ParsingException(this.getSyntaxErrorMessage("Parameter has too many parts."));
        }
        if (tokens.size() == 1) {
            definition.typeOnly = true;
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        FabricThreadManager.getInstance().createThread("FSYS:Activator.Upgrade", "Upgrades the software.", () -> {
            ServiceManager serviceManager = ((RuntimeContext)this.callable).getServiceManager();
            if (definition.typeOnly) {
                for (String serviceName : this.getServices(serviceManager)) {
                    if (!serviceName.startsWith(definition.getServiceName() + ".")) continue;
                    try {
                        this.doOperation(serviceManager, serviceName, session);
                    }
                    catch (Throwable exception) {
                        this.raiseSLMessageError(exception, session);
                    }
                }
            } else {
                this.doOperation(serviceManager, definition.getServiceName(), session);
            }
            this.raiseSLMessage(null, session);
        }).start();
        return new PseudoSLResponse();
    }

    protected abstract List<String> getServices(ServiceManager var1);

    protected void doOperation(ServiceManager serviceManager, String serviceName, MFSession session) {
        this.raiseSLMessage("\n" + this.getOperationName() + " service " + serviceName + "...", session);
        try {
            this.doOperation(serviceManager, serviceName);
            this.raiseSLMessage(" OK\n", session);
        }
        catch (Exception exception) {
            this.raiseSLMessageError(exception, session);
        }
    }

    protected abstract String getOperationName();

    protected abstract void doOperation(ServiceManager var1, String var2) throws ServiceManagerException;

    protected class ServiceCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext> {
        private AbstractServiceOperation.ServiceState state;

        ServiceCompletionAdviser(AbstractServiceOperation.ServiceState state) {
            this.state = state;
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            TreeSet<String> services = new TreeSet<String>();
            if (this.state == AbstractServiceOperation.ServiceState.NOT_LOADED) {
                List<String> registered = ((RuntimeContext)AbstractLoadUnloadServiceOperation.this.callable).getServiceManager().listRegisteredServices();
                registered.removeAll(((RuntimeContext)AbstractLoadUnloadServiceOperation.this.callable).getServiceManager().listLoadedServices());
                services.addAll(registered);
            } else {
                services.addAll(((RuntimeContext)AbstractLoadUnloadServiceOperation.this.callable).getServiceManager().listLoadedServices());
            }
            List<String> result = services.stream().map(name -> name.substring(0, name.indexOf("."))).distinct().sorted().collect(Collectors.toList());
            result.addAll(services);
            return result;
        }
    }

    protected static class Definition
    extends AbstractServiceOperation.ManifestDefinition {
        boolean typeOnly = false;

        protected Definition(String operationName, String serviceName) {
            super(operationName, serviceName);
        }

        protected void setTypeOnly(boolean typeOnly) {
            this.typeOnly = typeOnly;
        }
    }
}

