/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.selector;

import com.streamscape.lib.dispatcher.RangeConstraint;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.selector.AbstractRangeOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.RangeConstraintReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeRangeOperation
extends AbstractRangeOperation {
    public static final String NAME = "describe range";

    public DescribeRangeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE RANGE");
        this.syntax.addActionParameter(this.createRangeNameParameter(false, true, null));
        this.addLikeModifier();
        this.syntax.setCompactSyntax("describe range [[<RangeCategory>.]<RangeName>]\n   [like '<Pattern>' [as {xml | json}]]");
        this.syntax.setDescription("Shows information about the specified Range Constraint.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   like      - Returns a list of ranges whose name matches the specified pattern.\n     as xml  - Returns the result objects in XML format.\n     as json - Returns the result objects in JSON format.\n\n" + DescribeRangeOperation.getPatternDescription());
        this.syntax.setExamples("describe range TestRange\ndescribe range like 'Category1.*'");
        this.syntax.addCompletionCommand("list ranges");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getModerator().listRangeConstraints().stream().sorted().collect(Collectors.toList()));
        completions.add("like");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = new Definition(DescribeRangeOperation.getRangeName(statement), DescribeRangeOperation.getLikeParameterValue(statement), statement);
        if (definition.getEntityName() == null && definition.pattern == null) {
            throw new ParsingException(this.getSyntaxErrorMessage("At least one parameter must be specified."));
        }
        if (definition.getEntityName() != null && definition.pattern != null) {
            throw new ParsingException(this.getSyntaxErrorMessage("Range name and 'like' parameter cannot be specified together."));
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Moderator moderator = ((RuntimeContext)this.callable).getModerator();
        if (definition.pattern != null) {
            List<RangeConstraint> ranges = this.getSortedRanges(moderator.getRangeConstraints(definition.pattern).stream()).map(x$0 -> this.getUnderlyingRange((RangeConstraintReference)x$0)).collect(Collectors.toList());
            if (definition.statement.existsModifier("XML")) {
                return new SLResponse(((RuntimeContext)this.callable).getXSerializer().serialize(ranges));
            }
            if (definition.statement.existsModifier("JSON")) {
                return new SLResponse(((RuntimeContext)this.callable).getJSONSerializer().serialize(ranges));
            }
            RowSet result = new RowSet(DescribeRangeOperation.createResultDescriptor());
            ranges.forEach(range -> DescribeRangeOperation.addValues(result, new Object[]{range.getName(), range.getType(), DescribeRangeOperation.convert(range.getMinValue()), DescribeRangeOperation.convert(range.getMaxValue())}));
            return new SLResponse(result);
        }
        RowSet result = new RowSet(DescribeRangeOperation.createSimpleResultDescriptor());
        RangeConstraintReference range2 = moderator.lookupRangeConstraint(definition.getEntityName());
        if (range2 == null) {
            return new SLResponse("Range not found.", false);
        }
        DescribeRangeOperation.addValues(result, "Name", range2.getName());
        DescribeRangeOperation.addValues(result, "Description", DescribeRangeOperation.skipNull(range2.getDescription()));
        DescribeRangeOperation.addValues(result, new Object[]{"Type", range2.getType()});
        DescribeRangeOperation.addValues(result, "Min Value", DescribeRangeOperation.convert(range2.getMinValue()));
        DescribeRangeOperation.addValues(result, "Max Value", DescribeRangeOperation.convert(range2.getMaxValue()));
        return new SLResponse(result);
    }

    private static Object convert(Object value) {
        return value instanceof Date ? DescribeRangeOperation.formatDate((Date)value) : value;
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeRangeOperation.addColumn(result, "Name");
        DescribeRangeOperation.addColumn(result, "Type");
        DescribeRangeOperation.addColumn(result, "Min Value");
        DescribeRangeOperation.addColumn(result, "Max Value");
        return result;
    }

    static class Definition
    extends AbstractRangeOperation.AbstractDefinition {
        private String pattern;
        private DSLStatement statement;

        Definition(String rangeName, String pattern, DSLStatement statement) {
            super(DescribeRangeOperation.NAME, rangeName);
            this.pattern = pattern;
            this.statement = statement;
        }
    }
}

