/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.selector;

import com.streamscape.lib.dispatcher.DomainConstraint;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.selector.AbstractRangeOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSelectorOperation;
import com.streamscape.sef.moderator.DomainConstraintReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeDomainOperation
extends AbstractSelectorOperation {
    public static final String NAME = "describe domain constraint";

    public DescribeDomainOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE DOMAIN CONSTRAINT");
        this.addMainModifiers(true, false);
        this.addLikeModifier();
        this.syntax.setCompactSyntax("describe domain constraint [[<DomainCategory>.]<DomainName>]\n   [like '<Pattern>' [as {xml | json}]]");
        this.syntax.setDescription("Shows information about the specified Domain Constraint.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   like      - Returns a list of domains whose name matches the specified pattern.\n     as xml  - Returns the result objects in XML format.\n     as json - Returns the result objects in JSON format.\n\n" + DescribeDomainOperation.getPatternDescription());
        this.syntax.setExamples("describe domain constraint TestDomain\ndescribe domain constraint like 'Category1.*'");
        this.syntax.addCompletionCommand("list domain constraints");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getModerator().listDomainConstraints().stream().sorted().collect(Collectors.toList()));
        completions.add("like");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = new Definition(DescribeDomainOperation.getDomainName(statement), DescribeDomainOperation.getLikeParameterValue(statement), statement);
        if (definition.getEntityName() == null && definition.pattern == null) {
            throw new ParsingException(this.getSyntaxErrorMessage("At least one parameter must be specified."));
        }
        if (definition.getEntityName() != null && definition.pattern != null) {
            throw new ParsingException(this.getSyntaxErrorMessage("Domain name and 'like' parameter cannot be specified together."));
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Moderator moderator = ((RuntimeContext)this.callable).getModerator();
        if (definition.pattern != null) {
            List<DomainConstraint> domains = this.getSortedDomains(moderator.getDomainConstraints(definition.pattern).stream()).map(x$0 -> this.getUnderlyingDomain((DomainConstraintReference)x$0)).collect(Collectors.toList());
            if (definition.statement.existsModifier("XML")) {
                return new SLResponse(((RuntimeContext)this.callable).getXSerializer().serialize(domains));
            }
            if (definition.statement.existsModifier("JSON")) {
                return new SLResponse(((RuntimeContext)this.callable).getJSONSerializer().serialize(domains));
            }
            RowSet result = new RowSet(DescribeDomainOperation.createResultDescriptor());
            domains.forEach(domain -> DescribeDomainOperation.addValues(result, new Object[]{domain.getName(), domain.getType(), this.toString(domain.listValues(), false)}));
            return new SLResponse(result);
        }
        RowSet result = new RowSet(DescribeDomainOperation.createSimpleResultDescriptor());
        DomainConstraintReference domain2 = moderator.lookupDomainConstraint(definition.getEntityName());
        if (domain2 == null) {
            return new SLResponse("Domain not found.", false);
        }
        result.addToRowSet(new Object[]{"Domain", domain2.getName()});
        result.addToRowSet(new Object[]{"Description", DescribeDomainOperation.skipNull(domain2.getDescription())});
        result.addToRowSet(new Object[]{"Type", domain2.getType().name()});
        this.processValues(result, domain2.listByteValues(), Byte.class);
        this.processValues(result, domain2.listShortValues(), Short.class);
        this.processValues(result, domain2.listIntValues(), Integer.class);
        this.processValues(result, domain2.listLongValues(), Long.class);
        this.processValues(result, domain2.listFloatValues(), Float.class);
        this.processValues(result, domain2.listDoubleValues(), Double.class);
        this.processValues(result, domain2.listBigDecimalValues(), BigDecimal.class);
        this.processValues(result, domain2.listDateValues(), Date.class);
        this.processValues(result, domain2.listStringValues(), String.class);
        return new SLResponse(result);
    }

    private void processValues(RowSet result, List<?> values, Class type) {
        String printValue = this.toString(values, true);
        if (!printValue.isEmpty()) {
            DescribeDomainOperation.addValues(result, type.getSimpleName() + "[]", "{" + printValue + "}");
        }
    }

    private String toString(List<?> values, boolean sort) {
        return (sort ? values.stream().sorted() : values.stream()).map(value -> {
            Class<?> type = value.getClass();
            if (value.getClass() == Date.class) {
                return DescribeDomainOperation.formatDate((Date)value);
            }
            if (type == String.class) {
                return "'" + String.valueOf(value) + "'";
            }
            return value.toString();
        }).collect(Collectors.joining(","));
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeDomainOperation.addColumn(result, "Name");
        DescribeDomainOperation.addColumn(result, "Type");
        DescribeDomainOperation.addColumn(result, "Values");
        return result;
    }

    static class Definition
    extends AbstractRangeOperation.AbstractDefinition {
        private String pattern;
        private DSLStatement statement;

        Definition(String domainName, String pattern, DSLStatement statement) {
            super(DescribeDomainOperation.NAME, domainName);
            this.pattern = pattern;
            this.statement = statement;
        }
    }
}

