/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.selector;

import com.streamscape.runtime.mf.operation.selector.AbstractRangeOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class CreateRangeNumericOperation
extends AbstractRangeOperation {
    public static final String NAME = "create range numeric";

    public CreateRangeNumericOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE RANGE NUMERIC");
        this.addMainModifiers(true, false);
        this.addMinMaxModifiersNumeric(true);
        this.addDescriptionModifier();
        this.syntax.setDescription("Creates a new Numeric Range Constraint.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   min         - Minimum value of the range.\n   max         - Maximum value of the range.\n\nOptional parameters:\n\n   description - Description of the range.\n\nMin and max values can be numbers of any supported type.\nOptionally, the exact type of values can be specified.");
        this.syntax.setExamples("create range numeric Range1 min 10 max 20\ncreate range numeric Test.Range1 min 12.34 max 56.78 description 'Test range.'\ncreate range numeric Test.Range1 min 123 max 456 short");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parseNumericRangeParameters(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractRangeOperation.NumericRangeDefinition definition = (AbstractRangeOperation.NumericRangeDefinition)statement;
        this.getConnection().createRangeConstraint(definition.getEntityName(), definition.getDescription(), this.parseRangeValue(definition.minValue), this.parseRangeValue(definition.maxValue));
        return new SLResponse();
    }
}

