/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.selector;

import com.streamscape.runtime.mf.operation.selector.AbstractRangeOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class CreateRangeDateOperation
extends AbstractRangeOperation {
    public static final String NAME = "create range date";

    public CreateRangeDateOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE RANGE DATE");
        this.addMainModifiers(true, false);
        this.addMinMaxModifiersDate(true);
        this.addDescriptionModifier();
        this.syntax.setDescription("Creates a new Date Range Constraint.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   min         - Minimum value of the range.\n   max         - Maximum value of the range.\n\nOptional parameters:\n\n   description - Description of the range.\n\nMin and max values must be dates of the specified format.\nIf the format is not specified, '" + SCHEDULER_DATE_FORMAT.toPattern() + "' is used by default.");
        this.syntax.setExamples("create range date Range1 min '01/01/01' max '01/01/10' ('yy/MM/dd')\ncreate range date Test.Range1 min '05-31-2022 08:31:12 PM' max '05-31-2022 08:31:12 PM'\ncreate range date Test.Range1 min '01/01/01' max '01/01/10' ('yy/MM/dd') description 'Test range.'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parseDateRangeParameters(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractRangeOperation.DateRangeDefinition definition = (AbstractRangeOperation.DateRangeDefinition)statement;
        this.getConnection().createRangeConstraint(definition.getEntityName(), definition.getDescription(), definition.getMinValue(), definition.getMaxValue());
        return new SLResponse();
    }
}

