/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.selector;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSelectorOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import java.util.ArrayList;
import java.util.List;

public class CreateDomainOperation
extends AbstractSelectorOperation {
    public static final String NAME = "create domain constraint";

    public CreateDomainOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE DOMAIN CONSTRAINT");
        this.addMainModifiers(true, false);
        this.addDescriptionModifier();
        this.syntax.addModifier(this.createValuesModifier("", false, "                    "));
        this.syntax.setDescription("Creates a new Domain Constraint.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   description - Description of the domain.\n   values      - List of values that will be added to the domain.\n                 Value can be a number, string or date (strings and dates must be in single quotes).\n                 The exact type can be specified for the value if needed.\n                 If type is not specified, values in single quotes are processed as strings,\n                 other values are processed as numbers (of Int type by default).\n                 Also the format can be specified for dates. If the date format is not specified,\n                 '" + SCHEDULER_DATE_FORMAT.toPattern() + "' is used by default.");
        this.syntax.setExamples("create domain constraint Domain1\ncreate domain constraint Test.Domain1 description 'Test domain'\ncreate domain constraint Domain1 values(123, 456 long, 78.9d, 'Text')\ncreate domain constraint Domain1 values('1234' decimal, 4567 decimal(10, 2))\ncreate domain constraint Domain1 values('01/01/01' date('yy/MM/dd'), '05-31-2022 08:31:12 PM' date)");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = new Definition(CreateDomainOperation.getDomainName(statement), CreateDomainOperation.getDescription(statement));
        this.parseValues(statement, "ValuesBlock", definition.values);
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.getConnection().createDomainConstraint(definition.getEntityName(), definition.getDescription(), this.parseDomainValues(definition.values));
        return new SLResponse();
    }

    static class Definition
    extends AbstractSelectorOperation.AbstractDefinition {
        List<AbstractDSLOperation.PropertyValue> values = new ArrayList<AbstractDSLOperation.PropertyValue>();

        Definition(String domainName, String description) {
            super(CreateDomainOperation.NAME, domainName, description);
        }
    }
}

