/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.selector;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.runtime.mf.operation.selector.AbstractRangeOperation;
import com.streamscape.sdo.enums.RangeConstraintType;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.RangeConstraint;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class AlterRangeNumericOperation
extends AbstractRangeOperation {
    public static final String NAME = "alter range numeric";

    public AlterRangeNumericOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER RANGE NUMERIC");
        this.addMainModifiers(true, true, RangeConstraintType.NUMERIC);
        this.addMinMaxModifiersNumeric(false);
        this.addDescriptionModifier();
        this.syntax.setDescription("Alters the specified Numeric Range Constraint.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   min         - Minimum value of the range.\n   max         - Maximum value of the range.\n   description - Description of the range.\n\nMin and max values can be numbers of any supported type.\nOptionally, the exact type of values can be specified.");
        this.syntax.setExamples("alter range numeric Range1 min 10 max 20\nalter range numeric Test.Range1 min 12.34 max 56.78 description 'Test range.'\nalter range numeric Test.Range1 min 123 short\nalter range numeric Range1 'Test range.'\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        AbstractRangeOperation.NumericRangeDefinition definition = this.parseNumericRangeParameters(statement);
        if (definition.minValue == null && definition.maxValue == null && definition.getDescription() == null) {
            throw new ParsingException(this.getSyntaxErrorMessage("At least one parameter of 'min', 'max' or 'description' must be specified."));
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractRangeOperation.NumericRangeDefinition definition = (AbstractRangeOperation.NumericRangeDefinition)statement;
        FabricConnection connection = this.getConnection();
        RangeConstraint range = connection.getRangeConstraint(definition.getEntityName());
        if (range == null) {
            return new SLResponse("Range not found.", false);
        }
        if (definition.getDescription() != null) {
            range.setDescription(definition.getEntityName());
        }
        if (definition.minValue != null) {
            if (definition.maxValue != null) {
                range.setBoundaryValues(this.parseRangeValue(definition.minValue), this.parseRangeValue(definition.maxValue));
            } else {
                range.setMinValue(this.parseRangeValue(definition.minValue));
            }
        } else if (definition.maxValue != null) {
            range.setMaxValue(this.parseRangeValue(definition.maxValue));
        }
        connection.setRangeConstraint(range);
        return new SLResponse();
    }
}

