/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.selector;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.runtime.mf.operation.selector.AbstractRangeOperation;
import com.streamscape.sdo.enums.RangeConstraintType;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.RangeConstraint;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class AlterRangeDateOperation
extends AbstractRangeOperation {
    public static final String NAME = "alter range date";

    public AlterRangeDateOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER RANGE DATE");
        this.addMainModifiers(true, true, RangeConstraintType.DATE);
        this.addMinMaxModifiersDate(false);
        this.addDescriptionModifier();
        this.syntax.setDescription("Alters the specified Date Range Constraint.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   min         - Minimum value of the range.\n   max         - Maximum value of the range.\n\n   description - Description of the range.\n\nMin and max values must be dates of the specified format.\nIf the format is not specified, '" + SCHEDULER_DATE_FORMAT.toPattern() + "' is used by default.");
        this.syntax.setExamples("alter range date Range1 min '01/01/01' max '01/01/10' ('yy/MM/dd')\nalter range date Test.Range1 min '05-31-2022 08:31:12 PM'\nalter range date Test.Range1 description 'Test range.'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        AbstractRangeOperation.DateRangeDefinition definition = this.parseDateRangeParameters(statement);
        if (definition.minValue == null && definition.maxValue == null && definition.getDescription() == null) {
            throw new ParsingException(this.getSyntaxErrorMessage("At least one parameter of 'min', 'max' or 'description' must be specified."));
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractRangeOperation.DateRangeDefinition definition = (AbstractRangeOperation.DateRangeDefinition)statement;
        FabricConnection connection = this.getConnection();
        RangeConstraint range = connection.getRangeConstraint(definition.getEntityName());
        if (range == null) {
            return new SLResponse("Range not found.", false);
        }
        if (definition.getDescription() != null) {
            range.setDescription(definition.getDescription());
        }
        if (definition.minValue != null) {
            if (definition.maxValue != null) {
                range.setBoundaryValues(definition.getMinValue(), definition.getMaxValue());
            } else {
                range.setMinValue(definition.getMinValue());
            }
        } else if (definition.maxValue != null) {
            range.setMaxValue(definition.getMaxValue());
        }
        connection.setRangeConstraint(range);
        return new SLResponse();
    }
}

