/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.selector;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.DomainConstraint;
import com.streamscape.sef.dispatcher.AbstractSelectorOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.ArrayList;
import java.util.List;

public class AlterDomainOperation
extends AbstractSelectorOperation {
    public static final String NAME = "alter domain constraint";

    public AlterDomainOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER DOMAIN CONSTRAINT");
        this.addMainModifiers(true, true);
        this.addDescriptionModifier();
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("CLEAR VALUES"))).addModifier((AbstractModifier)this.createValuesModifier("REMOVE ", true, "                            ").setSyntaxHint(new SyntaxHint("  ", true))));
        this.syntax.addModifier(this.createValuesModifier("ADD ", false, "                        "));
        this.syntax.setDescription("Alters the specified Domain Constraint.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   description   - Description of the domain.\n\n   clear values  - Removes all values from the domain.\n   remove values - Removes the specified values from the domain.\n   add values    - Added the specified values to the domain.\n                   Value can be a number, string or date (strings and dates must be in single quotes).\n                   The exact type can be specified for the value if needed.\n                   If type is not specified, values in single quotes are processed as strings,\n                   other values are processed as numbers (of Int type by default).\n                   Also the format can be specified for dates. If the date format is not specified,\n                   '" + SCHEDULER_DATE_FORMAT.toPattern() + "' is used by default.");
        this.syntax.setExamples("alter domain constraint Domain1\nalter domain constraint Test.Domain1 description 'Test domain'\nalter domain constraint Domain1 add values(123, 456 long, 78.9d, 'String')\nalter domain constraint Domain1 clear values add values('1234' decimal, 4567 decimal(10, 2))\nalter domain constraint Domain1 remove values (1234 decimal)\nalter domain constraint Domain1 add values('01/01/01' date('yy/MM/dd'), '05-31-2022 08:31:12 PM' date)");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = new Definition(AlterDomainOperation.getDomainName(statement), AlterDomainOperation.getDescription(statement));
        if (statement.existsModifier("CLEAR VALUES")) {
            definition.clearValues = true;
        }
        this.parseValues(statement, "RemoveValuesBlock", definition.removedValues);
        this.parseValues(statement, "AddValuesBlock", definition.addedValues);
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        FabricConnection connection = this.getConnection();
        DomainConstraint domain = connection.getDomainConstraint(definition.getEntityName());
        if (domain == null) {
            return new SLResponse("Domain not found.", false);
        }
        if (definition.getDescription() != null) {
            domain.setDescription(definition.getDescription());
        }
        if (definition.clearValues) {
            domain.clear();
        }
        domain.removeValues(this.parseDomainValues(definition.removedValues));
        domain.addValues(this.parseDomainValues(definition.addedValues));
        connection.setDomainConstraint(domain);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSelectorOperation.AbstractDefinition {
        boolean clearValues = false;
        List<AbstractDSLOperation.PropertyValue> removedValues = new ArrayList<AbstractDSLOperation.PropertyValue>();
        List<AbstractDSLOperation.PropertyValue> addedValues = new ArrayList<AbstractDSLOperation.PropertyValue>();

        Definition(String domainName, String description) {
            super(AlterDomainOperation.NAME, domainName, description);
        }
    }
}

