/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.selector;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.enums.RangeConstraintType;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sef.dispatcher.AbstractSelectorOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.SetModifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.util.Date;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;

abstract class AbstractRangeOperation
extends AbstractSelectorOperation {
    AbstractRangeOperation() {
    }

    @Override
    protected void addMainModifiers(boolean required, boolean withCompletionAdviser) {
        this.addMainModifiers(required, withCompletionAdviser, null);
    }

    protected void addMainModifiers(boolean required, boolean withCompletionAdviser, RangeConstraintType type) {
        this.syntax.addActionParameter(this.createRangeNameParameter(required, withCompletionAdviser, type));
    }

    protected AbstractSelectorOperation.ConstraintParameter createRangeNameParameter(boolean required, boolean withCompletionAdviser, RangeConstraintType type) {
        AbstractSelectorOperation.ConstraintParameter range = new AbstractSelectorOperation.ConstraintParameter("Range", required);
        if (withCompletionAdviser) {
            range.setCompletionAdviser(this.createCompletionAdviser(type));
        }
        return range;
    }

    protected AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext> createCompletionAdviser(final RangeConstraintType type) {
        return new AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext>(){

            @Override
            protected List<String> doGetCompletions(String processedScript, MFSession session) {
                return ((RuntimeContext)AbstractRangeOperation.this.callable).getModerator().getRangeConstraints().stream().filter(range -> type == null || range.getType().equals((Object)type)).map(NamedObject::getName).sorted().collect(Collectors.toList());
            }
        };
    }

    protected void addMinMaxModifiersNumeric(boolean required) {
        this.addBoundaryModifiers(required, (modifier, token) -> modifier.addParameter(new ExpressionParameter(token + "Value")));
        this.syntax.addModifier(this.createPropertyTypeModifierExtended(AbstractDSLOperation.PropertyTypes.NUMERIC_ONLY, false, null, false));
    }

    protected void addMinMaxModifiersDate(boolean required) {
        this.addBoundaryModifiers(required, (modifier, token) -> modifier.addParameter(new StringParameter(token + "Value")));
        this.syntax.addModifier(((SetModifier)new SetModifier("FormatSet").setRequired(false)).addModifier((AbstractModifier)new Modifier().addParameter(new StringParameter("Format"))));
    }

    private void addBoundaryModifiers(boolean required, BiFunction<CompoundModifier, String, CompoundModifier> modifierCompleter) {
        this.syntax.addModifier(modifierCompleter.apply(this.createBoundaryModifier("Min", required), "Min"));
        this.syntax.addModifier((AbstractModifier)modifierCompleter.apply(this.createBoundaryModifier("Max", required), "Max").setSyntaxHintSpace());
    }

    private CompoundModifier createBoundaryModifier(String token, boolean required) {
        return new CompoundModifier(required).addModifier(new Modifier(token));
    }

    protected NumericRangeDefinition parseNumericRangeParameters(DSLStatement statement) throws ParsingException {
        NumericRangeDefinition definition = new NumericRangeDefinition(this.getName(), AbstractRangeOperation.getRangeName(statement), AbstractRangeOperation.getDescription(statement));
        if (statement.existsModifier("Min")) {
            definition.minValue = new AbstractDSLOperation.PropertyValue(statement.getParameter("MinValue").getValue());
            this.parseTypeAndFormat(statement, definition.minValue);
            if (statement.existsModifier("Max")) {
                definition.maxValue = new AbstractDSLOperation.PropertyValue(statement.getParameter("MaxValue").getValue(), definition.minValue);
            }
            return definition;
        }
        if (statement.existsModifier("Max")) {
            definition.maxValue = new AbstractDSLOperation.PropertyValue(statement.getParameter("MaxValue").getValue());
            this.parseTypeAndFormat(statement, definition.maxValue);
        }
        return definition;
    }

    protected DateRangeDefinition parseDateRangeParameters(DSLStatement statement) throws ParsingException {
        DateRangeDefinition definition = new DateRangeDefinition(this.getName(), AbstractRangeOperation.getRangeName(statement), AbstractRangeOperation.getDescription(statement));
        AbstractRangeOperation.parseBoundaryParameter(statement, "MinValue", definition::setMinValue);
        AbstractRangeOperation.parseBoundaryParameter(statement, "MaxValue", definition::setMaxValue);
        definition.format = AbstractRangeOperation.getFormat(statement);
        return definition;
    }

    private static void parseBoundaryParameter(DSLStatement statement, String parameter, Consumer<String> valueSetter) {
        if (statement.existsParameter(parameter)) {
            valueSetter.accept(statement.getParameter(parameter).getValue());
        }
    }

    static class NumericRangeDefinition
    extends AbstractDefinition {
        AbstractDSLOperation.PropertyValue minValue;
        AbstractDSLOperation.PropertyValue maxValue;

        NumericRangeDefinition(String operationName, String rangeName, String description) {
            super(operationName, rangeName, description);
        }

        void setMinValue(AbstractDSLOperation.PropertyValue minValue) {
            this.minValue = minValue;
        }

        void setMaxValue(AbstractDSLOperation.PropertyValue maxValue) {
            this.maxValue = maxValue;
        }
    }

    static class DateRangeDefinition
    extends AbstractDefinition {
        String minValue;
        String maxValue;
        String format;

        DateRangeDefinition(String operationName, String rangeName, String description) {
            super(operationName, rangeName, description);
        }

        void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        void setFormat(String format) {
            this.format = format;
        }

        protected Date getMinValue() throws Exception {
            return AbstractRangeOperation.parseDateValue(this.minValue, this.format);
        }

        protected Date getMaxValue() throws Exception {
            return AbstractRangeOperation.parseDateValue(this.maxValue, this.format);
        }
    }

    static class AbstractDefinition
    extends AbstractSelectorOperation.AbstractDefinition {
        AbstractDefinition(String name, String rangeName) {
            super(name, rangeName);
        }

        AbstractDefinition(String name, String rangeName, String description) {
            super(name, rangeName, description);
        }
    }
}

