/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class ResetPermissionsOperation
extends AbstractSecurityOperation {
    private static final String NAME = "reset permissions";

    public ResetPermissionsOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("RESET PERMISSIONS");
        this.syntax.addModifier((AbstractModifier)new CompoundModifier().addModifier(new Modifier("ON")).addModifier(new Modifier("USER", false)).addParameter(new IdentifierParameter("User")).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Resets the access permissions of the specified user.\nAfter resetting the user takes the access permissions from its groups.");
        this.syntax.setExamples("reset permissions on User1\nreset permissions on user User1");
    }

    private ChoiceModifier createPermissionModifier() {
        ChoiceModifier result = (ChoiceModifier)((ChoiceModifier)new ChoiceModifier("Permission").setCompactSyntax("<Permission>")).setSyntaxHint(SyntaxHint.SPACE);
        for (String value : AccessControlOperation.slangValues()) {
            result.addModifier(new Modifier(value));
        }
        return result;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("User").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.getSecurityManager(session).resetUserPermissions(((Definition)statement).userName);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String userName;

        public Definition(String userName) {
            super(ResetPermissionsOperation.NAME);
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }
    }
}

