/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.mf.operation.security.AbstractUserOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class ResetPasswordOperation
extends AbstractUserOperation {
    private static final String NAME = "reset password";

    public ResetPasswordOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("RESET PASSWORD").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.setDescription("Resets a password for the specified user.");
        this.syntax.setExamples("reset password User1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        String newPassword = this.getSecurityManager(session).resetPassword(((Definition)statement).userName);
        return new SLResponse("New password: " + newPassword);
    }

    public static class Definition
    extends AbstractSLStatement {
        private String userName;

        public Definition(String userName) {
            super(ResetPasswordOperation.NAME);
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }
    }
}

