/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Subject;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class RemoveUserFromGroupOperation
extends AbstractSecurityOperation {
    private static final String NAME = "remove user from group";

    public RemoveUserFromGroupOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REMOVE");
        this.syntax.setSubject((Subject)new Subject("USER").addParameter((SyntaxParameter)new ExpressionParameter("UserName").setCompletionAdviser(new AbstractSecurityOperation.UsersAdviser())));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("FROM GROUP").addParameter((SyntaxParameter)new ExpressionParameter("GroupName").setCompletionAdviser(new AbstractSecurityOperation.GroupsAdviser()))).setIncludeToDefinition(true)).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Removes the specified user from the specified group.");
        this.syntax.setExamples("remove user User1 from group Group1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("UserName").getValue(), statement.getParameter("GroupName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.getSecurityManager(session).removeUserFromGroup(definition.userName, definition.groupName);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String userName;
        private String groupName;

        public Definition(String userName, String groupName) {
            super(RemoveUserFromGroupOperation.NAME);
            this.userName = userName;
            this.groupName = groupName;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getGroupName() {
            return this.groupName;
        }
    }
}

