/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.Collections;
import java.util.List;

public class ListUsersOperation
extends AbstractSecurityOperation {
    private static final String NAME = "list users";

    public ListUsersOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST USERS");
        this.syntax.setDescription("Returns a list of all users in the sysplex.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListUsersOperation.createResultDescriptor());
        List<User> users = this.getSecurityManager(session).getUsers();
        Collections.sort(users);
        for (User user : users) {
            result.addToRowSet(new Object[]{user.getName(), user.getOrganization(), user.getState(), user.isDropBoxOwner(), ListUsersOperation.formatDate(user.getLastAccessTimestamp()), ListUsersOperation.formatDate(user.getLastFailedAttemptTimestamp()), ListUsersOperation.formatDate(user.getCreationTimestamp())});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListUsersOperation.addColumn(result, "Name");
        ListUsersOperation.addColumn(result, "Organization");
        ListUsersOperation.addColumn(result, "State");
        ListUsersOperation.addColumn(result, "Create DropBox");
        ListUsersOperation.addColumn(result, "Last Access Time");
        ListUsersOperation.addColumn(result, "Last Failed Attempt");
        ListUsersOperation.addColumn(result, "Created On");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListUsersOperation.NAME);
        }
    }
}

