/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.sef.security.Organization;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.Collections;
import java.util.List;

public class ListOrganizationsOperation
extends AbstractSecurityOperation {
    private static final String NAME = "list organizations";

    public ListOrganizationsOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST ORGANIZATIONS");
        this.syntax.setDescription("Returns a list of all organizations in the sysplex.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListOrganizationsOperation.createResultDescriptor());
        List<Organization> organizations = this.getSecurityManager(session).getOrganizations();
        Collections.sort(organizations);
        for (Organization organization : organizations) {
            result.addToRowSet(new Object[]{organization.getName(), organization.getDomain(), organization.isValid()});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListOrganizationsOperation.addColumn(result, "Name");
        ListOrganizationsOperation.addColumn(result, "Domain");
        ListOrganizationsOperation.addColumn(result, "Valid");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListOrganizationsOperation.NAME);
        }
    }
}

