/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.sef.security.Group;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.Collections;
import java.util.List;

public class ListGroupsOperation
extends AbstractSecurityOperation {
    private static final String NAME = "list groups";

    public ListGroupsOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST GROUPS");
        this.syntax.setDescription("Returns a list of all groups in the sysplex.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListGroupsOperation.createResultDescriptor());
        List<Group> groups = this.getSecurityManager(session).getGroups();
        Collections.sort(groups);
        for (Group group : groups) {
            result.addToRowSet(new Object[]{group.getName(), group.getOrganization(), group.isValid()});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListGroupsOperation.addColumn(result, "Name");
        ListGroupsOperation.addColumn(result, "Organization");
        ListGroupsOperation.addColumn(result, "Valid");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListGroupsOperation.NAME);
        }
    }
}

