/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.mf.operation.security.AbstractGrantRevokeOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.tools.lexer.BufferUtils;
import java.util.List;

public class GrantOperation
extends AbstractGrantRevokeOperation {
    private static final String NAME = "grant";

    public GrantOperation() {
        super(NAME, "to");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            String script = BufferUtils.normalizeCommand(comp.scriptToComplete).toLowerCase().trim();
            if (script.contains("to")) {
                this.fillUsersAndGroups(this.getSecurityManager(session), GrantOperation.getPrefix(script, "to"), completions);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    AbstractGrantRevokeOperation.Definition createDefinition(AccessControlOperation permission, String grantee, AbstractGrantRevokeOperation.GrantOption option, String dataspace) {
        return new AbstractGrantRevokeOperation.Definition(NAME, permission, grantee, option, dataspace);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractGrantRevokeOperation.Definition definition = (AbstractGrantRevokeOperation.Definition)statement;
        SecurityManager securityManager = this.getSecurityManager(session);
        if (definition.grantOption.equals((Object)AbstractGrantRevokeOperation.GrantOption.USEON)) {
            return this.invokeUseOn(definition);
        }
        if (securityManager.existsUser(definition.grantee)) {
            securityManager.addUserPermission(definition.grantee, definition.permission);
        } else if (securityManager.existsGroup(definition.grantee)) {
            securityManager.addGroupPermission(definition.grantee, definition.permission);
        } else {
            return new SLResponse("User or group '" + definition.grantee + "' does not exist.", false);
        }
        return new SLResponse();
    }
}

