/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.mf.operation.security.AbstractUserOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class EnableUserOperation
extends AbstractUserOperation {
    private static final String NAME = "enable user";

    public EnableUserOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ENABLE USER").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.setDescription("Enables the specified user.");
        this.syntax.setExamples("enable user User1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.getSecurityManager(session).enableUser(((Definition)statement).userName);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String userName;

        public Definition(String userName) {
            super(EnableUserOperation.NAME);
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }
    }
}

