/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.mf.operation.security.AbstractUserOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class DropUserOperation
extends AbstractUserOperation {
    private static final String NAME = "drop user";

    public DropUserOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP USER").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.addModifier(new Modifier("IF EXISTS", false));
        this.syntax.setDescription("Drops the specified user from the sysplex.");
        this.syntax.setExamples("drop user User1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue(), statement.existsModifier("IF EXISTS"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        SecurityManager securityManager = this.getSecurityManager(session);
        if (!((Definition)statement).ifExists || securityManager.existsUser(((Definition)statement).userName)) {
            securityManager.dropUser(((Definition)statement).userName);
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String userName;
        private boolean ifExists;

        public Definition(String userName, boolean ifExists) {
            super(DropUserOperation.NAME);
            this.userName = userName;
            this.ifExists = ifExists;
        }

        public String getUserName() {
            return this.userName;
        }
    }
}

