/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.mf.operation.security.AbstractOrganizationOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class DropOrganizationOperation
extends AbstractOrganizationOperation {
    private static final String NAME = "drop organization";

    public DropOrganizationOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP ORGANIZATION").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.setDescription("Drops the specified organization from the sysplex.");
        this.syntax.setExamples("drop organization Org1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.getSecurityManager(session).dropOrganization(((Definition)statement).organizationName);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String organizationName;

        public Definition(String organizationName) {
            super(DropOrganizationOperation.NAME);
            this.organizationName = organizationName;
        }

        public String getUserName() {
            return this.organizationName;
        }
    }
}

