/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.mf.operation.security.AbstractGroupOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class DropGroupOperation
extends AbstractGroupOperation {
    private static final String NAME = "drop group";

    public DropGroupOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP GROUP").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.setDescription("Drops the specified group from the sysplex.");
        this.syntax.setExamples("drop group Group1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.getSecurityManager(session).dropGroup(((Definition)statement).groupName);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String groupName;

        public Definition(String groupName) {
            super(DropGroupOperation.NAME);
            this.groupName = groupName;
        }

        public String getUserName() {
            return this.groupName;
        }
    }
}

