/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.mf.operation.security.AbstractUserOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class DisableUserOperation
extends AbstractUserOperation {
    private static final String NAME = "disable user";

    public DisableUserOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DISABLE USER").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.setDescription("Disables the specified user.\nDisabled user still exists in the sysplex, but further authentication will always fail for him.\nSo, such user cannot create new components (connections, services or dataspaces) or connect to the sysplex.");
        this.syntax.setExamples("disable user User1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.getSecurityManager(session).disableUser(((Definition)statement).userName);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String userName;

        public Definition(String userName) {
            super(DisableUserOperation.NAME);
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }
    }
}

