/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.security.AbstractUserOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.vcard.Address;
import com.streamscape.sdo.vcard.EMail;
import com.streamscape.sdo.vcard.Name;
import com.streamscape.sdo.vcard.Org;
import com.streamscape.sdo.vcard.Phone;
import com.streamscape.sdo.vcard.PhoneUse;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DescribeUserOperation
extends AbstractUserOperation {
    private static final String NAME = "describe user";

    public DescribeUserOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE USER").addActionParameter((SyntaxParameter)((IdentifierParameter)((IdentifierParameter)new IdentifierParameter("Name").setRequired(false)).addExclusionValues("ACL", "ACL AT", "OWNER", "OWNERSHIP", "PERMISSIONS", "ATTRIBUTES", "ACCESS", "PROFILE")).setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser(){

            @Override
            protected List<String> doGetCompletions(String processedScript, MFSession session) {
                try {
                    return DescribeUserOperation.this.getSecurityManager(session).listUsers();
                }
                catch (SecurityManagerException ignored) {
                    return new ArrayList<String>();
                }
            }
        }));
        ChoiceModifier options = new ChoiceModifier("Options", false);
        options.addModifier((AbstractModifier)new Modifier("ACL AT").addParameter(new ExpressionParameter("Dataspace")));
        options.addModifier(new CompoundModifier("OwnershipAccess").addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier().addModifier((AbstractModifier)new Modifier("OWNERSHIP").setAlias("OWNER"))).addModifier(new Modifier("ACCESS"))).addModifier(new AtNodeOrAtDomainModifier()));
        options.addModifier(new Modifier("PERMISSIONS"));
        options.addModifier(new Modifier("ATTRIBUTES"));
        options.addModifier(new CompoundModifier("UserProfile").addModifier(new Modifier("PROFILE")).addModifier(new CompoundModifier("AsFormat", false).addModifier(new Modifier("AS")).addModifier(new Modifier("FULL", false)).addModifier(new ChoiceModifier("Format").addPossibleValues("XML", "JSON"))));
        options.setCompactSyntax("[{acl at <Dataspace> |\n  ownership | owner | access [{at | @} {node <NodeName> | domain}] |\n  permissions |\n  attributes |\n  profile [as [full] {xml | json}]}]");
        this.syntax.addModifier(options);
        this.syntax.setDescription("Shows information about the specified user.");
        this.syntax.setSyntaxDescription("Current user of the session is used if the user name is not specified.\n\nOptional parameters:\n\n   acl at <Dataspace> - Shows Access Control List of the user for the specified dataspace.\n                        Parameter 'Dataspace' must have the following format: [<NodeName>://]<DataspaceType>.<DataspaceName>\n   ownership          - Shows all components that are owned by the user in the current node.\n      at node <Node>  - Shows all owned components in the specified node.\n      at domain       - Shows all owned components in the sysplex.\n   access             - Shows information about the user access in the current node.\n      at node <Node>  - Shows information about the user access in the specified node.\n      at domain       - Shows information about the user access in the sysplex.\n   permissions        - Shows all access permissions of the user.\n   attributes         - Shows all attributes of the user.\n   profile            - Shows the full profile (vCard) of the user.\n      as xml          - Shows the user's profile serialized in XML format.\n      as json         - Shows the user's profile serialized in JSON format.\n      as full xml     - Shows the user's profile serialized in XML format including the photo data.\n      as full json    - Shows the user's profile serialized in JSON format including the photo data.");
        this.syntax.setExamples("describe user User1\ndescribe user acl at TSPACE.Test\ndescribe user owner\ndescribe user User1 ownership at domain\ndescribe user permissions\ndescribe user attributes\ndescribe user login\ndescribe user login at domain\ndescribe user User1 profile\ndescribe user profile as xml\ndescribe user User1 profile as json\ndescribe user profile as full xml\ndescribe user User1 profile as full json");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition result = new Definition(statement.getParameter("Name").getValue(), this.getOptionalParameter(statement), statement.existsParameter("Dataspace") ? statement.getParameter("Dataspace").getValue() : null, AtNodeOrAtDomainModifier.getValue(statement), this.getProfileFormat(statement));
        this.parseDataspaceName(result);
        return result;
    }

    private ProfileFormat getProfileFormat(DSLStatement statement) {
        if (statement.existsModifier("XML")) {
            return statement.existsModifier("FULL") ? ProfileFormat.FULL_XML : ProfileFormat.XML;
        }
        if (statement.existsModifier("JSON")) {
            return statement.existsModifier("FULL") ? ProfileFormat.FULL_JSON : ProfileFormat.JSON;
        }
        return null;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).getNodeName(), statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SecurityManager securityManager = this.getSecurityManager(session);
        User user = securityManager.lookupUser(definition.getUserName() != null ? definition.getUserName() : session.getOwnerName());
        if (user == null) {
            throw new Exception("User not found.");
        }
        if (definition.getParameter() == AbstractSecurityOperation.OptionalParameter.ACL) {
            return this.doInvokeAcl(user.getName().toString(), definition.getDataspace(), timeout);
        }
        RowSet result = new RowSet(DescribeUserOperation.createResultDescriptor(definition.getParameter()));
        if (definition.getParameter() == AbstractSecurityOperation.OptionalParameter.OWNERSHIP) {
            this.addOwnership(user.getName().toString(), result);
        } else if (definition.getParameter() == AbstractSecurityOperation.OptionalParameter.PERMISSIONS) {
            this.addPermissions(securityManager.getUserPermissions(user.getName().toString()), result);
            result.addToRowSet(new Object[]{"create dropbox", user.isDropBoxOwner()});
        } else if (definition.getParameter() == AbstractSecurityOperation.OptionalParameter.ATTRIBUTES) {
            this.addAttributes(user, result);
        } else if (definition.getParameter() == AbstractSecurityOperation.OptionalParameter.ACCESS) {
            this.addAccess(user, result);
        } else {
            if (definition.getParameter() == AbstractSecurityOperation.OptionalParameter.OTHER) {
                return this.doInvokeProfile(definition, securityManager, user.getName().toString(), result);
            }
            result.addToRowSet(new Object[]{"Name", user.getName()});
            result.addToRowSet(new Object[]{"Alias", DescribeUserOperation.skipNull(user.getAlias())});
            result.addToRowSet(new Object[]{"Description", DescribeUserOperation.skipNull(user.getDescription())});
            result.addToRowSet(new Object[]{"Organization", user.getOrganization()});
            result.addToRowSet(new Object[]{"State", user.getState()});
            result.addToRowSet(new Object[]{"Permissions", user.hasOwnPermissions() ? "User" : "Inherited"});
            result.addToRowSet(new Object[]{"DN", DescribeUserOperation.skipNull(user.getDNRecordWithoutSystemAttributes())});
            result.addToRowSet(new Object[]{"Distinguished Entity", user.isDistinguishedEntity()});
            result.addToRowSet(new Object[]{"Sudo Capable", user.isSudoCapable()});
            result.addToRowSet(new Object[]{"Create DropBox", user.isDropBoxOwner()});
            result.addToRowSet(new Object[]{"Groups", user.listGroups()});
            DescribeUserOperation.addTimestamp(result, "Created On", user.getCreationTimestamp());
            DescribeUserOperation.addTimestamp(result, "Last Access Time", user.getLastAccessTimestamp());
            DescribeUserOperation.addTimestamp(result, "Last Failed Attempt", user.getLastFailedAttemptTimestamp());
        }
        return new SLResponse(result);
    }

    private void addAttributes(User user, RowSet result) {
        List attributes = user.listAttributes().stream().sorted().collect(Collectors.toList());
        attributes.stream().filter(name -> !User.isSystemAttribute(name)).forEach(name -> this.addAttribute(user, (String)name, false, result));
        attributes.stream().filter(User::isSystemAttribute).forEach(name -> this.addAttribute(user, (String)name, true, result));
    }

    private void addAttribute(User user, String attributeName, boolean isSystem, RowSet result) {
        DescribeUserOperation.add(result, new Object[]{attributeName, user.getAttribute(attributeName), isSystem});
    }

    private void addAccess(User user, RowSet result) {
        DescribeUserOperation.add(result, new Object[]{((RuntimeContext)this.callable).getName(), DescribeUserOperation.formatTimestamp(user.getLastAccessTimestamp()), DescribeUserOperation.formatTimestamp(user.getLastFailedAttemptTimestamp())});
    }

    private static void addTimestamp(RowSet result, String column, Date timestamp) {
        DescribeUserOperation.add(result, new Object[]{column, DescribeUserOperation.formatTimestamp(timestamp)});
    }

    public static String formatTimestamp(Date timestamp) {
        return timestamp != null ? DATE_TIME_FORMAT.format(timestamp) : "n/a";
    }

    private SLResponse doInvokeProfile(Definition definition, SecurityManager securityManager, String userName, RowSet result) throws Exception {
        vCard vcard = securityManager.getVCard(userName);
        if (vcard == null) {
            throw new Exception("Profile is not available.");
        }
        if (definition.format == ProfileFormat.XML || definition.format == ProfileFormat.FULL_XML) {
            String xml = ((RuntimeContext)this.callable).getXSerializer().serialize(vcard);
            if (definition.format == ProfileFormat.XML && xml.contains("<BINVAL>")) {
                xml = xml.replaceFirst("<BINVAL>.*</BINVAL>", "<BINVAL>...</BINVAL>");
            }
            return new SLResponse(xml);
        }
        if (definition.format == ProfileFormat.JSON || definition.format == ProfileFormat.FULL_JSON) {
            String json = ((RuntimeContext)this.callable).getJSONSerializer().serialize(vcard);
            if (definition.format == ProfileFormat.JSON && json.contains("\"BINVAL\":")) {
                json = json.replaceFirst("\"BINVAL\":.*\"}", "\"BINVAL\":\"...\"}");
            }
            return new SLResponse(json);
        }
        result.addToRowSet(new Object[]{"Full Name", DescribeUserOperation.skipNull(vcard.getFullName())});
        Name name = vcard.getName();
        if (name != null) {
            result.addToRowSet(new Object[]{"Family Name", DescribeUserOperation.skipNull(name.getFamilyName())});
            result.addToRowSet(new Object[]{"Given Name", DescribeUserOperation.skipNull(name.getGivenName())});
            result.addToRowSet(new Object[]{"Middle Name", DescribeUserOperation.skipNull(name.getMiddleName())});
        }
        result.addToRowSet(new Object[]{"Nickname", DescribeUserOperation.skipNull(vcard.getNickName())});
        result.addToRowSet(new Object[]{"URL", DescribeUserOperation.skipNull(vcard.getURL())});
        result.addToRowSet(new Object[]{"Birthday", DescribeUserOperation.skipNull(vcard.getBirthday())});
        Org org = vcard.getOrganization();
        if (org != null) {
            result.addToRowSet(new Object[]{"Organization Name", DescribeUserOperation.skipNull(org.getOrganizationName())});
            result.addToRowSet(new Object[]{"Organization Unit", DescribeUserOperation.skipNull(org.getOrganizationUnit())});
        }
        result.addToRowSet(new Object[]{"Title", DescribeUserOperation.skipNull(vcard.getTitle())});
        result.addToRowSet(new Object[]{"Role", DescribeUserOperation.skipNull(vcard.getRole())});
        DescribeUserOperation.addPhones(vcard::getHomePhone, "Home", result);
        DescribeUserOperation.addAddress(vcard.getHomeAddress(), "Home", result);
        DescribeUserOperation.addPhones(vcard::getWorkPhone, "Work", result);
        DescribeUserOperation.addAddress(vcard.getWorkAddress(), "Work", result);
        DescribeUserOperation.addEmail(vcard::getHomeEMail, "Home", result);
        DescribeUserOperation.addEmail(vcard::getWorkEMail, "Work", result);
        result.addToRowSet(new Object[]{"Jabber ID", DescribeUserOperation.skipNull(vcard.getJID())});
        result.addToRowSet(new Object[]{"Description", DescribeUserOperation.skipNull(vcard.getDescription())});
        result.addToRowSet(new Object[]{"Age", DescribeUserOperation.skipNull(vcard.getAge())});
        result.addToRowSet(new Object[]{"Gender", DescribeUserOperation.skipNull(vcard.getGender())});
        result.addToRowSet(new Object[]{"Marital Status", DescribeUserOperation.skipNull(vcard.getMaritalStatus())});
        result.addToRowSet(new Object[]{"Location", DescribeUserOperation.skipNull(vcard.getLocation())});
        result.addToRowSet(new Object[]{"Photo", vcard.getPhoto() != null && vcard.getPhoto().hasPhoto()});
        return new SLResponse(result);
    }

    private static void addPhones(Function<PhoneUse, Phone> getter, String type, RowSet result) throws Exception {
        Phone phone = getter.apply(PhoneUse.CELL);
        if (phone != null) {
            result.addToRowSet(new Object[]{type + " Cell", DescribeUserOperation.skipNull(phone.getNumber())});
        }
        if ((phone = getter.apply(PhoneUse.VOICE)) != null) {
            result.addToRowSet(new Object[]{type + " Voice", DescribeUserOperation.skipNull(phone.getNumber())});
        }
        if ((phone = getter.apply(PhoneUse.FAX)) != null) {
            result.addToRowSet(new Object[]{type + " Fax", DescribeUserOperation.skipNull(phone.getNumber())});
        }
        if ((phone = getter.apply(PhoneUse.MSG)) != null) {
            result.addToRowSet(new Object[]{type + " Message", DescribeUserOperation.skipNull(phone.getNumber())});
        }
        if ((phone = getter.apply(PhoneUse.PAGER)) != null) {
            result.addToRowSet(new Object[]{type + " Pager", DescribeUserOperation.skipNull(phone.getNumber())});
        }
    }

    private static void addAddress(Address address, String type, RowSet result) throws Exception {
        if (address != null) {
            result.addToRowSet(new Object[]{type + " Address", DescribeUserOperation.skipNull(address.getExtendedAddress())});
            result.addToRowSet(new Object[]{type + " Street", DescribeUserOperation.skipNull(address.getStreet())});
            result.addToRowSet(new Object[]{type + " Locality", DescribeUserOperation.skipNull(address.getLocality())});
            result.addToRowSet(new Object[]{type + " Region", DescribeUserOperation.skipNull(address.getRegion())});
            result.addToRowSet(new Object[]{type + " Postal Code", DescribeUserOperation.skipNull(address.getPostalCode())});
            result.addToRowSet(new Object[]{type + " Country", DescribeUserOperation.skipNull(address.getCountry())});
        }
    }

    private static void addEmail(Supplier<EMail> getter, String type, RowSet result) throws Exception {
        EMail eMail = getter.get();
        if (eMail != null) {
            result.addToRowSet(new Object[]{type + " E-mail", DescribeUserOperation.skipNull(eMail.getUserId())});
        }
    }

    private static RowMetaData createResultDescriptor(AbstractSecurityOperation.OptionalParameter parameter) {
        RowMetaData result = new RowMetaData();
        if (parameter == AbstractSecurityOperation.OptionalParameter.OWNERSHIP) {
            DescribeUserOperation.addColumn(result, "Node");
            DescribeUserOperation.addColumn(result, "Type");
            DescribeUserOperation.addColumn(result, "Name");
            DescribeUserOperation.addColumn(result, "Model");
            DescribeUserOperation.addColumn(result, "Scope");
            DescribeUserOperation.addColumn(result, "Owner");
        } else if (parameter == AbstractSecurityOperation.OptionalParameter.PERMISSIONS) {
            DescribeUserOperation.addColumn(result, "Permission");
            DescribeUserOperation.addColumn(result, "Allowed");
        } else if (parameter == AbstractSecurityOperation.OptionalParameter.ATTRIBUTES) {
            DescribeUserOperation.addColumn(result, "Name");
            DescribeUserOperation.addColumn(result, "Value");
            DescribeUserOperation.addColumn(result, "System");
        } else if (parameter == AbstractSecurityOperation.OptionalParameter.ACCESS) {
            DescribeUserOperation.addColumn(result, "Node");
            DescribeUserOperation.addColumn(result, "Last Access Time");
            DescribeUserOperation.addColumn(result, "Last Failed Attempt");
        } else {
            DescribeUserOperation.addColumn(result, "Property");
            DescribeUserOperation.addColumn(result, "Value");
        }
        return result;
    }

    @Override
    protected AbstractSecurityOperation.OptionalParameter getOtherOptionalParameter(DSLStatement statement) {
        return statement.existsModifier("PROFILE") ? AbstractSecurityOperation.OptionalParameter.OTHER : null;
    }

    public static class Definition
    extends AbstractSecurityOperation.AbstractDescribeGroupUserDefinition {
        private ProfileFormat format;

        public Definition(String userName, AbstractSecurityOperation.OptionalParameter parameter, String dataspace, String nodeName, ProfileFormat format) {
            super(DescribeUserOperation.NAME, userName, parameter, dataspace, nodeName);
            this.format = format;
        }

        public String getUserName() {
            return this.owner;
        }

        public ProfileFormat getFormat() {
            return this.format;
        }
    }

    public static enum ProfileFormat {
        XML,
        FULL_XML,
        JSON,
        FULL_JSON;

    }
}

