/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.mf.operation.security.AbstractOrganizationOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DescribeOrganizationOperation
extends AbstractOrganizationOperation {
    private static final String NAME = "describe organization";

    public DescribeOrganizationOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE ORGANIZATION").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.addModifier((AbstractModifier)new Modifier("MEMBERS", false).setSyntaxHintSpace());
        this.syntax.setDescription("Shows information about the specified organization.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   members - Shows a list of all members of the organization.");
        this.syntax.setExamples("describe organization Org1\ndescribe organization Org1 members");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue(), statement.existsModifier("MEMBERS"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SecurityManager securityManager = this.getSecurityManager(session);
        Organization organization = securityManager.lookupOrganization(definition.organizationName);
        return organization != null ? new SLResponse(this.createResult(securityManager, organization, definition.members)) : new SLResponse("Organization not found.", false);
    }

    private RowSet createResult(SecurityManager securityManager, Organization organization, boolean needMembers) throws Exception {
        RowSet result = new RowSet(DescribeOrganizationOperation.createResultDescriptor(needMembers));
        ArrayList<String> groups = new ArrayList<String>();
        List<String> users = organization.listMembers();
        this.splitMembers(securityManager, groups, users);
        if (needMembers) {
            DescribeOrganizationOperation.fillMembers(groups, users, result);
        } else {
            result.addToRowSet(new Object[]{"Name", organization.getName()});
            result.addToRowSet(new Object[]{"Description", DescribeOrganizationOperation.skipNull(organization.getDescription())});
            result.addToRowSet(new Object[]{"Domain", organization.getDomain()});
            result.addToRowSet(new Object[]{"Valid", organization.isValid()});
            result.addToRowSet(new Object[]{"Groups", groups});
            result.addToRowSet(new Object[]{"Users", users});
        }
        return result;
    }

    private void splitMembers(SecurityManager securityManager, List<String> groups, List<String> users) throws Exception {
        List<String> allGroups = securityManager.listGroups();
        Iterator<String> iterator = users.iterator();
        while (iterator.hasNext()) {
            String member = iterator.next();
            if (Collections.binarySearch(allGroups, member) < 0) continue;
            groups.add(member);
            iterator.remove();
        }
    }

    private static void fillMembers(List<String> groups, List<String> users, RowSet result) throws Exception {
        int nGroups = groups.size();
        int nUsers = users.size();
        int nMax = Math.max(nGroups, nUsers);
        for (int i = 0; i < nMax; ++i) {
            result.addToRowSet(new Object[]{i < nGroups ? groups.get(i) : "", i < nUsers ? users.get(i) : ""});
        }
    }

    private static RowMetaData createResultDescriptor(boolean members) {
        RowMetaData result = new RowMetaData();
        if (members) {
            DescribeOrganizationOperation.addColumn(result, "Group");
            DescribeOrganizationOperation.addColumn(result, "User");
        } else {
            DescribeOrganizationOperation.addColumn(result, "Property");
            DescribeOrganizationOperation.addColumn(result, "Value");
        }
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String organizationName;
        private boolean members;

        public Definition(String groupName, boolean members) {
            super(DescribeOrganizationOperation.NAME);
            this.organizationName = groupName;
            this.members = members;
        }

        public String getUserName() {
            return this.organizationName;
        }

        public boolean isMembers() {
            return this.members;
        }
    }
}

