/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.security.AbstractGroupOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.sql.SQLException;

public class DescribeGroupOperation
extends AbstractGroupOperation {
    private static final String NAME = "describe group";

    public DescribeGroupOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE GROUP").addActionParameter((SyntaxParameter)new IdentifierParameter("Name").addExclusionValues("ACL", "OWNER", "OWNERSHIP", "PERMISSIONS", "MEMBERS"));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier((AbstractModifier)new Modifier("ACL AT").addParameter(new ExpressionParameter("Dataspace")))).addModifier(new CompoundModifier("UserOwnership").addModifier((AbstractModifier)new Modifier("OWNERSHIP").setAlias("OWNER")).addModifier(new AtNodeOrAtDomainModifier()))).addModifier(new Modifier("PERMISSIONS"))).addModifier(new Modifier("MEMBERS"))).setCompactSyntax("[{acl at <Dataspace> |\n  ownership | owner [{at | @} {node <NodeName> | domain}] |\n  permissions |\n  members}]"));
        this.syntax.setDescription("Shows information about the specified group.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   acl at <Dataspace> - Shows Access Control List of the group for the specified dataspace.\n                        Parameter 'Dataspace' must have the following format: [<NodeName>://]<DataspaceType>.<DataspaceName>\n   members            - Shows a list of all members of the group.\n   ownership          - Shows all components that are owned by the group in the current node.\n      at node <Node>  - Shows all owned components in the specified node.\n      at domain       - Shows all owned components in the sysplex.\n   permissions        - Shows all access permissions of the group.");
        this.syntax.setExamples("describe group Group1\ndescribe group Group1 acl at TSPACE.Test\ndescribe group Group1 owner\ndescribe group Group1 ownership at domain\ndescribe group Group1 members\ndescribe group Group1 permissions");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition result = new Definition(statement.getParameter("Name").getValue(), this.getOptionalParameter(statement), statement.existsParameter("Dataspace") ? statement.getParameter("Dataspace").getValue() : null, AtNodeOrAtDomainModifier.getValue(statement));
        this.parseDataspaceName(result);
        return result;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).getNodeName(), statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SecurityManager securityManager = this.getSecurityManager(session);
        Group group = securityManager.lookupGroup(definition.getGroupName());
        if (group == null) {
            throw new Exception("Group not found.");
        }
        if (definition.getParameter() == AbstractSecurityOperation.OptionalParameter.ACL) {
            return this.doInvokeAcl(group.getName().toString(), definition.getDataspace(), timeout);
        }
        RowSet result = new RowSet(DescribeGroupOperation.createResultDescriptor(definition.getParameter()));
        if (definition.getParameter() == AbstractSecurityOperation.OptionalParameter.OWNERSHIP) {
            this.addOwnership(group.getName().toString(), result);
        } else if (definition.getParameter() == AbstractSecurityOperation.OptionalParameter.PERMISSIONS) {
            this.addPermissions(securityManager.getGroupPermissions(group.getName().toString()), result);
        } else if (definition.getParameter() == AbstractSecurityOperation.OptionalParameter.OTHER) {
            group.listUsers().forEach(user -> {
                try {
                    result.addToRowSet(new Object[]{user});
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            });
        } else {
            result.addToRowSet(new Object[]{"Name", group.getName()});
            result.addToRowSet(new Object[]{"Description", DescribeGroupOperation.skipNull(group.getDescription())});
            result.addToRowSet(new Object[]{"Organization", group.getOrganization()});
            result.addToRowSet(new Object[]{"Valid", group.isValid()});
            result.addToRowSet(new Object[]{"Users", group.listUsers()});
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor(AbstractSecurityOperation.OptionalParameter parameter) {
        RowMetaData result = new RowMetaData();
        if (parameter == AbstractSecurityOperation.OptionalParameter.OWNERSHIP) {
            DescribeGroupOperation.addColumn(result, "Node");
            DescribeGroupOperation.addColumn(result, "Type");
            DescribeGroupOperation.addColumn(result, "Name");
            DescribeGroupOperation.addColumn(result, "Model");
            DescribeGroupOperation.addColumn(result, "Scope");
            DescribeGroupOperation.addColumn(result, "Owner");
        } else if (parameter == AbstractSecurityOperation.OptionalParameter.PERMISSIONS) {
            DescribeGroupOperation.addColumn(result, "Permission");
            DescribeGroupOperation.addColumn(result, "Allowed");
        } else if (parameter == AbstractSecurityOperation.OptionalParameter.OTHER) {
            DescribeGroupOperation.addColumn(result, "Member");
        } else {
            DescribeGroupOperation.addColumn(result, "Property");
            DescribeGroupOperation.addColumn(result, "Value");
        }
        return result;
    }

    @Override
    protected AbstractSecurityOperation.OptionalParameter getOtherOptionalParameter(DSLStatement statement) {
        return statement.existsModifier("MEMBERS") ? AbstractSecurityOperation.OptionalParameter.OTHER : null;
    }

    public static class Definition
    extends AbstractSecurityOperation.AbstractDescribeGroupUserDefinition {
        public Definition(String groupName, AbstractSecurityOperation.OptionalParameter parameter, String dataspace, String nodeName) {
            super(DescribeGroupOperation.NAME, groupName, parameter, dataspace, nodeName);
        }

        public String getGroupName() {
            return this.owner;
        }
    }
}

