/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.security;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.dispatcher.AbstractSecurityOperation;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;

public class CreateUserOperation
extends AbstractSecurityOperation {
    public static final String NAME = "create user";

    public CreateUserOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        CreateUserOperation.doFillSyntax(this.syntax);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return CreateUserOperation.doConvertDslToSl(statement, this.getSyntax(null));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return CreateUserOperation.doInvoke(statement, this.getSecurityManager(session));
    }

    public static DSLStatementSyntax doFillSyntax(DSLStatementSyntax syntax) {
        syntax.setAction("CREATE USER").addActionParameter(new IdentifierParameter("Name"));
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("PASSWORD", false).addParameter(new StringParameter("Password"))).setSyntaxHintSpace());
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION", false).addParameter(new StringParameter("Description"))).setSyntaxHintSpace());
        CreateUserOperation.addProfileSyntax(syntax, false);
        syntax.setDescription("Creates a new user with the specified parameters.");
        syntax.setSyntaxDescription("Optional parameters:\n\n   password    - Password of the user. It must be a non-empty string\n                 If the password is not set, the new user will be created with a null password.\n   description - Description of the user.\n   profile     - Profile (vCard) of the user.");
        syntax.setExamples("create user Bob\ncreate user Bob password '123'\ncreate user Bob password '123' description 'Example user.'\ncreate user Bob password '123' profile full name 'Bobby' role 'Developer' photo 'C:/Pictures/Bob.jpeg'");
        return syntax;
    }

    public static SLStatement doConvertDslToSl(DSLStatement statement, String syntax) throws ParsingException {
        return new Definition(statement, syntax, statement.getParameter("Password").getValue(), statement.getParameter("Description").getValue());
    }

    public static SLResponse doInvoke(SLStatement statement, SecurityManager securityManager) throws Exception {
        Definition definition = (Definition)statement;
        securityManager.createUser(definition.userName, definition.password, definition.description, CreateUserOperation.getProfile(definition.statement));
        return new SLResponse();
    }

    private static vCard getProfile(DSLStatement statement) throws Exception {
        if (statement.existsModifier("PROFILE")) {
            vCard vcard = new vCard();
            CreateUserOperation.setProfile(vcard, statement);
            return vcard;
        }
        return null;
    }

    public static class Definition
    extends AbstractSecurityOperation.AbstractAlterCreateUserDefinition {
        private String password;
        private String description;

        public Definition(DSLStatement statement, String syntax, String password, String description) throws ParsingException {
            super(CreateUserOperation.NAME, statement, syntax);
            this.password = password;
            this.description = description;
        }

        public String getPassword() {
            return this.password;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

